% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcub0q.R
\name{fastcub0q}
\alias{fastcub0q}
\title{Main function for CUB models with covariates for the feeling component}
\usage{
fastcub0q(m,ordinal,W,starting=NULL,maxiter,toler,iterc=3,invgen=TRUE)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of selected covariates for explaining the feeling component, not including intercept}

\item{starting}{Starting values for the algorithm}

\item{maxiter}{Maximum number of iterations allowed for running the optimization algorithm}

\item{toler}{Fixed error tolerance for final estimates}

\item{iterc}{Iteration from which the acceleration strategy starts}

\item{invgen}{Logical: should the recursive formula for the inverse of the information matrix be considered? (Default is TRUE)}
}
\value{
An object of the class "fastCUB"
}
\description{
Function to estimate and validate a CUB model for given ordinal responses, with covariates for
explaining the feeling component.
}
\keyword{internal}
