% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Biomass.Estimation.R
\name{Biomass.Estimation}
\alias{Biomass.Estimation}
\title{Fresh Weight Determination from the Projected Area of the Plant}
\usage{
Biomass.Estimation(Biomass, PA, model = c("lm", "ANN", "SVM"), newPA)
}
\arguments{
\item{Biomass}{ground truth fresh biomass of the above ground plant parts for the model development}

\item{PA}{a numeric value representing projected area (in cm square) of the above ground plant parts from the visual image of the plant}

\item{model}{the applied machine learning model i.e., "lm" or, "ANN" or,"SVM"}

\item{newPA}{out of sample projected area (in cm square) of the above ground plant parts from the visual image of the plant}
}
\value{
Fresh weight in gm
}
\description{
The projected area obtained from the visual image of the plant is used as input to the machine learning model (Linear Model, Artificial Neural Network, and Support Vector Regression) to determine the plant's fresh weight.
}
\examples{
y=c(28.3,19.8,13,17.4,13.8,18.5,8.5,19.1)# Ground truth fresh biomass
x=c(4426.7,2993.9,1913.5,1966.3,2008.8,2297.6,1564.9,2541.6)# projected area of the plant
x1=c(3683.062,2548.309,2677.843,2669.239,1933.728)# out of sample projected area (in cm square)

Biomass.Estimation(Biomass=y,PA=x,model="ANN",newPA = x1)

}
\references{
Patil, S. B., & Bodhe, S. K. (2011). Betel leaf area measurement using image processing. \emph{International Journal on Computer Science and Engineering}, 3(7), 2656-2660.
\cr Misra, T., Marwaha, S., Arora, A., Ray, M.,Kumar, S., Kumar, S. (2021). Leaf area assessment using image processing and support vector regression in rice. \emph{Indian Journal of Agricultural Sciences}, 91 (3), 388–92.
}
\keyword{FreshWeight}
\keyword{ImageAnalysis}
\keyword{RGB}
