% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothC++.R
\name{smooth}
\alias{smooth}
\title{Compute the smoothing distribution of the Fleming-Viot latent signal}
\usage{
smooth(fvddp.past, fvddp.future, t.past, t.future, y.new)
}
\arguments{
\item{fvddp.past}{An instance of class \code{fvddp}, progressively updated ad propagated
with data referring to past times via \code{\link[=update]{update()}} and \code{\link[=propagate]{propagate()}}
(or its approximate version, \code{\link[=approx.propagate]{approx.propagate()}}).}

\item{fvddp.future}{Same as \code{fvddp.past}, but in this case the propagation has
been performed with time data from times later than the one to be estimated. Its
hyperparameters must be equals to the ones of \code{fvddp.past}.}

\item{t.past}{The time between the last collection of data (in the past) and the
time at which the smoothing is performed.}

\item{t.future}{Same as \code{t.past}, but in this case it is referred to the future.
\code{t.future} is positive too.}

\item{y.new}{The data collected at the time the smoothing is performed.}
}
\value{
The function returns an instance of class \code{fvddp} whose hyperparametrs
are the same of \code{fvddp.past} and \code{fvddp.future}. The values of \code{y.star}and  \code{M}
are such that to represent the state of the FVDDP signal in the present time,
i.e. the one Which is \code{t.past} away from the time at which \code{fvddp.past} i
estimated, and is \code{t.future} away from the time at which \code{fvddp.future} is ,
estimated. Since the computation is usually extemely long, one can rely on the
Monte-Carlo approximation provided by \code{\link[=approx.smooth]{approx.smooth()}}.
}
\description{
Compute the smoothing distribution of the Fleming-Viot latent signal
}
\examples{
#create wo process and sequentilly update and propagate them
FVDDP = initialize(3, function(x) rbinom(x, 10, .2),
                   function(x) dbinom(x, 10, .2), TRUE)
#for the past
FVDDP.PAST = update(FVDDP, c(2,3))
#for the future
FVDDP.FUTURE = update(FVDDP, c(4))
FVDDP.FUTURE = propagate(FVDDP.FUTURE, 0.5)
FVDDP.FUTURE = update(FVDDP.FUTURE, c(1))
#get a smoothed  FVDDP merging them (with new values too)
smooth(fvddp.past = FVDDP.PAST, fvddp.future = FVDDP.FUTURE,
       t.past= 0.4, t.future = 0.3, y.new = c(1,3))

}
\references{
{
\insertRef{AscolaniLijoiRuggiero2023}{FVDDPpkg}
}
}
\seealso{
\code{\link[=approx.smooth]{approx.smooth()}} for a (faster) approximation based on importance
sampling.
}
