% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune}
\alias{prune}
\title{Reduce the size of Fleming-Viot Dependent Dirichlet Processes}
\usage{
prune(fvddp, eps)
}
\arguments{
\item{fvddp}{An object of class \code{fvddp}, generated via \code{\link[=initialize]{initialize()}}.}

\item{eps}{The value behold which the weights are removed, with their components
of the mixture. \code{eps} has to be in the interval (0,1).}
}
\value{
An \code{fvddp} list of smaller size of the input. Precisely, the components
whose weight goes below the treshold \code{eps} will be removed: the vector \code{w} and
the matrix \code{M} will have a lower amount of rows; if the latter will include all-zero
columns, they will be removed.
}
\description{
Reduce the size of Fleming-Viot Dependent Dirichlet Processes
}
\examples{
#create a large process
FVDDP = initialize(3, function(x) rexp(x, 4),
                   function(x) dexp(x, 4), FALSE)
FVDDP = update(FVDDP, c(rep(rexp(1, 3), 7), rep(rexp(1, 5), 5), rexp(1, 7), 3))
FVDDP = propagate(FVDDP, 1)
prune(fvddp = FVDDP, eps = 1e-4)

}
\references{
{
\insertRef{AscolaniLijoiRuggiero2023}{FVDDPpkg}
}
}
