% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriorsampling.R
\name{posterior.sample}
\alias{posterior.sample}
\title{Draw values from the posterior distribution FVDDP}
\usage{
posterior.sample(fvddp, N)
}
\arguments{
\item{fvddp}{The instance of class \code{fvddp} the values are drawn from.}

\item{N}{The amount of values to draw.}
}
\value{
A vector of length \code{N} of values drawn either from the centering of the
FVDDP (the input) or from the empirical probability measure generated by past
observations. The difference between this function and \code{\link[=predictive.struct]{predictive.struct()}}
is that in this case the process is not update with respect to any drawn value.
}
\description{
Draw values from the posterior distribution FVDDP
}
\examples{
#create a dummy process and sample some values from it
FVDDP = initialize(7, function(x) rbeta(x, 3,3),
                   function(x) dgamma(x, 3,3), FALSE)
FVDDP = update(FVDDP, rep(0:1, 2))
posterior.sample(fvddp = FVDDP, N = 100)
}
