% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorestimate.R
\name{error.estimate}
\alias{error.estimate}
\title{Compare the performance of a Monte-Carlo estimate with respect to the exact result.}
\usage{
error.estimate(fvddp.exact, fvddp.approx, remove.unmatched = FALSE)
}
\arguments{
\item{fvddp.exact}{An instance of class \code{fvddp} obtained via smoothing
(\code{\link[=smooth]{smooth()}}) or propagation (\code{\link[=propagate]{propagate()}}).}

\item{fvddp.approx}{An instance of class \code{fvddp} obtained using the approximating
algorithms for smoothing or propagation, with the same input as \code{fvddp.exact}.}

\item{remove.unmatched}{Choose whether the weights associated to multiplicities
that are in \code{fvddp.exact} but not in \code{fvddp.approx} should be removed in the
computation (\code{TRUE}) or considered to be 0 (\code{FALSE}).}
}
\value{
A vector whose j-th element is the difference (in absolute value) between
the weight of the j-th row of the matrix \code{M} of \code{fvddp.exact} and the weight
of the row of the matrix \code{M} of \code{fvddp.approx} equal to it. The length depends
on the value of \code{remove.unmathced}.
}
\description{
Compare the performance of a Monte-Carlo estimate with respect to the exact result.
}
\examples{
#iniialize the process
FVDDP = initialize(3, function(x) rgamma(x, 2,2),
                   function(x) dgamma(x, 2,2), FALSE)
FVDDP = update(FVDDP, c(rep(abs(rnorm(2,1, 4)), 2), rexp(2, 0.5)))
#perform n exact propagation and an approximate one
EXACT = propagate(FVDDP, 0.7)
APPROX = approx.propagate(FVDDP, 0.7, 10000)
#measure the error with this function
error.estimate(fvddp.exact = EXACT, fvddp.approx = APPROX, TRUE)

#in order to smoot, create and propagate the signal from the past and from the future
FVDDP=initialize(3, function(x) rbinom(x, 10, 0.2),
                 function(x) dbinom(x, 10, 0.2), TRUE)
FVDDP.PAST = update(FVDDP, c(2,3))
FVDDP.FUTURE = update(FVDDP, c(4))
FVDDP.FUTURE = propagate(FVDDP.FUTURE, 0.5)
FVDDP.FUTURE = update(FVDDP.FUTURE, c(1))
#compute an exact and an approximate smoothing
EXACT = smooth(FVDDP.PAST, FVDDP.FUTURE, 0.4, 0.3, c(1,3))
APPROX = approx.smooth(FVDDP.PAST, FVDDP.FUTURE, 0.4, 0.3, c(1,3), 20000)
#compute the error again
error.estimate(fvddp.exact = EXACT, fvddp.approx = APPROX)
}
