% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgp.far.R
\name{dgp.far}
\alias{dgp.far}
\title{FAR(p) Data Generator}
\usage{
dgp.far(J, N, S = 0.5, p = 1, kernel = "Gaussian", burn_in = 50)
}
\arguments{
\item{J}{The number of grid points for each curve observation.}

\item{N}{The sample size, representing the number of curves to be generated.}

\item{S}{The serial dependence factor for the kernel used in the FAR(p) process. Default is 0.5.}

\item{p}{The order of the autoregressive process. Default is 1.}

\item{kernel}{The type of kernel function \eqn{\psi} used for the autoregressive process. Can be "Gaussian" or "Wiener". Default is "Gaussian".}

\item{burn_in}{The number of initial points discarded to eliminate transient effects. Default is 50.}
}
\value{
A \eqn{J \times N} matrix where each column contains a curve evaluated at \eqn{J} grid points, generated from the FAR(p) model.
}
\description{
It generates functional data that follows a functional autoregressive process of order \eqn{p}, denoted as FAR(p). The generated data consists of curves evaluated at discrete grid points.
}
\details{
The functional autoregressive model of order \eqn{p} is given by:
\deqn{X_i(t) -\mu(t) = \sum_{j=1}^{p} \Psi(X_{i-j}-\mu)(t) + \epsilon_i(t),}
where \eqn{\Psi(X)(t) = \int \psi(t,s)X(s) dt} is the kernel operator, and \eqn{\epsilon_i(t)} are i.i.d. errors generated from a standard Brownian motion process.
The mean function \eqn{\mu} is assumed to be zero in the generating process.
}
\examples{
\donttest{
# Generate discrete evaluations of 200 curves, each observed at 50 grid points.
yd_far = dgp.far(J = 50, N = 200, S = 0.7, p = 2, kernel = "Gaussian", burn_in = 50)
}

}
