% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FREEtree_PC.r
\name{FREEtree_PC}
\alias{FREEtree_PC}
\title{Version of FREEtree called when fixed_regress is NULL, uses principal
components (PC) as regressors for non-grey modules.}
\usage{
FREEtree_PC(
  data,
  fixed_split,
  var_select,
  power,
  minModuleSize,
  cluster,
  maxdepth_factor_screen,
  maxdepth_factor_select,
  Fuzzy,
  minsize_multiplier,
  alpha_screen,
  alpha_select,
  alpha_predict
)
}
\arguments{
\item{data}{data to train or test FREEtree on.}

\item{fixed_split}{user specified char vector of features to be used in
splitting with certainty.}

\item{var_select}{a char vector containing features to be selected. These
features will be clustered by WGCNA and the chosen ones will be used in
regression and splitting.}

\item{power}{soft thresholding power parameter of WGCNA.}

\item{minModuleSize}{WGCNA's minimum module size parameter.}

\item{cluster}{the variable name of each cluster (in terms of random effect) using glmer's implementation.}

\item{maxdepth_factor_screen}{when selecting features from one module, the
maxdepth of the glmertree is set to ceiling function of
maxdepth_factor_screen*(features in that module). Default is 0.04.}

\item{maxdepth_factor_select}{Given screened features (from each modules, if
Fuzzy=FALSE, that is the selected non-grey features from each non-grey
modules), we want to select again from those screened features. The
maxdepth of that glmertree is set to be ceiling of
maxdepth_factor_select*(#screened features). Default is 0.6. for the
maxdepth of the prediction tree (final tree), maxdepth is set to the length
of the split_var (fixed+chosen ones).}

\item{Fuzzy}{boolean to indicate desire to screen like Fuzzy Forest if Fuzzy
= TRUE; if Fuzzy= FALSE, first screen within non-grey modules and then
select the final non-grey features within the selected ones from each
non-grey module; Use this final non-grey features as regressors (plus
fixed_regress) and use grey features as split_var to select grey features.
Then use final non-grey features and selected grey features together in
splitting and regression variables, to do the final prediction. Fuzzy=FALSE
is used if there are so many non-grey features and you want to protect grey
features.}

\item{minsize_multiplier}{At the final prediction tree, the minsize =
minsize_multiplier times the length of final regressors. The default is 5.
Note that we only set minsize for the final prediction tree instead of
trees at the feature selection step since during feature selection, we
don't have to be so careful. Note that when tuning the parameters, larger
alpha and samller minsize_multiplier will result in deeper tree and
therefore may cause overfitting problem. It is recommended to decrease
alpha and decrease minsize_multiplier at the same time.}

\item{alpha_screen}{alpha used in screening step.}

\item{alpha_select}{alpha used in selection step.}

\item{alpha_predict}{alpha used in prediction step.}
}
\value{
a glmertree object (trained tree).
dictionary'with keys=name of color,values=names of features of that color
}
\description{
Version of FREEtree called when fixed_regress is NULL, uses principal
components (PC) as regressors for non-grey modules.
}
