% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFMMPeaks.R
\name{getFMMPeaks}
\alias{getFMMPeaks}
\title{Peak and trough times and signal values}
\usage{
getFMMPeaks(objFMM, timePointsIn2pi = TRUE)
}
\arguments{
\item{objFMM}{Object of class \code{'FMM'}}

\item{timePointsIn2pi}{\code{TRUE} to return peak and trough times in the \eqn{[0, 2\pi]} interval. When \code{timePointsIn2pi = FALSE} the positions of peak and trough times are returned. Its default value is \code{TRUE}.}
}
\value{
A list with the following components is returned:
\item{tpeakU}{a numeric vector with the time points at which the peak of each wave is estimated.}
\item{tpeakL}{a numeric vector with the time points at which the trough of each wave is estimated.}
\item{ZU}{a numeric vector with the estimated signal peak values of each wave.}
\item{ZL}{a numeric vector with the estimated signal trough values of each wave.}
}
\description{
\code{getFMMPeaks()} is used to estimate peak and trough times and signal values at those times for each component of the model. These parameters result to be useful in multiple applications.
}
\examples{
## Generate example data:
fmm2.data <- generateFMM(0, rep(2, 2), c(1.5, 3.4), c(0.2, 2.3), c(0.1, 0.2),
                         plot = FALSE, outvalues = TRUE,
                         sigmaNoise = 0.5) # add a gaussian noise with sigma = 0.5

## Fit the FMM model with nback = 2 components
## fit is an object of S4 class 'FMM'
fit <- fitFMM(fmm2.data$y,timePoints = fmm2.data$t,nback = 2,
              lengthAlphaGrid = 24,lengthOmegaGrid = 10)
getFMMPeaks(fit, timePointsIn2pi = TRUE) # times in the [0,2*pi] interval

}
\references{
Rueda C, Larriba Y, Peddada SD (2019).
Frequency Modulated Moebius Model Accurately Predicts Rhythmic Signals in Biological and Physical Sciences.
\emph{Scientific reports}, \bold{9} (1), 18701. \url{https://www.nature.com/articles/s41598-019-54569-1}
}
