% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_plotting_functions.R
\name{plot_util_distr}
\alias{plot_util_distr}
\title{plots resulting track over map with uncertainty shown by space utilisation distribution}
\usage{
plot_util_distr(
  Result,
  dates = NULL,
  map.options = NULL,
  percentiles = c(0.4, 0.6, 0.8),
  zoom = "auto",
  geom_polygon.options = NULL,
  save.options = NULL,
  color.palette = NULL,
  use.palette = TRUE,
  background = NULL,
  plot = TRUE,
  save = TRUE
)
}
\arguments{
\item{Result}{FLightR result object obtained from \code{\link{run.particle.filter}}}

\item{dates}{Use NULL if all twilights will be used for plotting, one integer if specific twilight should be plotted (line number in Result$Results$Quantiles). Use data.frame with first column - start of the period and second - end of the period and each line represents a new period to plot specific periods, e.g. wintering or migration.}

\item{map.options}{options passed to \code{\link[ggmap]{get_map}}, note that \code{zoom} option is defined separately}

\item{percentiles}{Probability breaks for utilisation distribution}

\item{zoom}{Zoom for map. If 'auto' FLightR will try to find optimal zoom level by downloading different size maps and checking whether all the points fit the map.}

\item{geom_polygon.options}{options passed to \code{\link[ggplot2]{geom_polygon}}}

\item{save.options}{options passed to \code{\link[ggplot2]{ggsave}}. Filename should be defined here.}

\item{color.palette}{colors for probability contours. Either NULL or \code{\link[grDevices]{colorRampPalette}} object}

\item{use.palette}{should the same colors be used for polygon boundaries as for polygon filling?}

\item{background}{if provided will be used as a background. Must be created by \code{link[ggmap]{get_map}}}

\item{plot}{should function produce a plot?}

\item{save}{should function save results with \code{\link[ggplot2]{ggsave}}?}
}
\value{
list with two parts 
        \item{res_buffers}{spatial buffers for defined probability values}
        \item{p}{\code{\link[ggplot2]{ggplot}} object}
}
\description{
May be use not only for the whole track but for a set of specific dates, e.g. to show spatial uncertainty during migration. Note that you can use it only after obtaining and registering in you current session Google Api Key. For details on the API key check [here](http://ornithologyexchange.org/forums/topic/38315-mapflightrggmap-error).
}
\examples{
File<-system.file("extdata", "Godwit_TAGS_format.csv", package = "FLightR")
# to run example fast we will cut the real data file by 2013 Aug 20
Proc.data<-get.tags.data(File, end.date=as.POSIXct('2013-06-25', tz='GMT'))
Calibration.periods<-data.frame(
       calibration.start=as.POSIXct(c(NA, "2014-05-05"), tz='GMT'),
       calibration.stop=as.POSIXct(c("2013-08-20", NA), tz='GMT'),
       lon=5.43, lat=52.93) 
       #use c() also for the geographic coordinates, if you have more than one calibration location
       # (e. g.,  lon=c(5.43, 6.00), lat=c(52.93,52.94))

# NB Below likelihood.correction is set to FALSE for fast run! 
# Leave it as default TRUE for real examples
Calibration<-make.calibration(Proc.data, Calibration.periods, likelihood.correction=FALSE)

Grid<-make.grid(left=0, bottom=50, right=10, top=56,
  distance.from.land.allowed.to.use=c(-Inf, Inf),
  distance.from.land.allowed.to.stay=c(-Inf, Inf))

all.in<-make.prerun.object(Proc.data, Grid, start=c(5.43, 52.93),
                             Calibration=Calibration, threads=1)
# here we will run only 1e4 partilces for a very short track.
# One should use 1e6 particles for the full run
Result<-run.particle.filter(all.in, threads=1,
           nParticles=1e3, known.last=TRUE,
           precision.sd=25, check.outliers=FALSE)

\dontrun{
plot_util_distr(Result, zoom=6, save=FALSE)
}

}
\author{
Eldar Rakhimberdiev
}
