% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{edit_nodes}
\alias{edit_nodes}
\title{Edit nodes in an FFT definition}
\usage{
edit_nodes(
  fft,
  nodes = NA,
  class = NA,
  cue = NA,
  direction = NA,
  threshold = NA,
  exit = NA,
  quiet = FALSE
)
}
\arguments{
\item{fft}{One FFT definition
(as a data frame in tidy format, with one row per node).}

\item{nodes}{The FFT nodes to be edited (as an integer vector).
Default: \code{nodes = NA}.}

\item{class}{The class values of \code{nodes} (as character).}

\item{cue}{The cue names of \code{nodes} (as character).}

\item{direction}{The direction values of \code{nodes} (as character).}

\item{threshold}{The threshold values of \code{nodes} (as character).}

\item{exit}{The exit values of \code{nodes} (as values from \code{exit_types}).}

\item{quiet}{Hide feedback messages (as logical)?
Default: \code{quiet = FALSE}.}
}
\value{
One FFT definition
(as a data frame in tidy format, with one row per node).
}
\description{
\code{edit_nodes} allows manipulating
one or more \code{nodes} from an existing FFT definition
(in the tidy data frame format).

\code{edit_nodes} allows to directly set and change the value(s) of
\code{class}, \code{cue}, \code{direction}, \code{threshold}, and \code{exit},
in an FFT definition for the specified \code{nodes}.

There is only rudimentary verification for plausible entries.
Importantly, however, as \code{edit_nodes} is ignorant of \code{data},
the values of its variables are not validated for a specific set of data.

Repeated changes of a node are possible
(by repeating the corresponding integer value in \code{nodes}).
}
\seealso{
\code{\link{add_nodes}} for adding nodes to an FFT definition;
\code{\link{drop_nodes}} for deleting nodes from an FFT definition;
\code{\link{flip_exits}} for reversing exits in an FFT definition;
\code{\link{reorder_nodes}} for reordering nodes of an FFT definition;
\code{\link{select_nodes}} for selecting nodes in an FFT definition;
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{flip_exits}()},
\code{\link{get_fft_df}()},
\code{\link{read_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
