% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamStress.R
\name{beamStress}
\alias{beamStress}
\title{beamStress}
\usage{
beamStress(beamP, beamT, Y, Length, MoI, RotAng, BND)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{Y}{Value of Young's (Elastic) modulus}

\item{Length}{Length of beam}

\item{MoI}{Moment of Inertia}

\item{RotAng}{Angle of rotation}

\item{BND}{Global nodal displacement matrix, return from function beamNodeDis}
}
\value{
Completes FEM by calculating values of stress and strain, produces three (3) [3 x n] matrix.
\item{BendingStress}{Bending Stress}
}
\description{
Calculates local stress and strain for beam elements
}
\examples{
data(beamGeo)
data(beamGLforce)

Length = beamDime$Length
MoI = beamDime$MomentofInertia
RotAng = beamDime$Angle
BND = beamND

beamBendStress = beamStress(beamGeo$beamP, beamGeo$beamT, beamGeo$Y, Length, MoI, RotAng, BND)

}
