% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamGLForces.R
\name{beamGLForces}
\alias{beamGLForces}
\title{beamGLForces}
\usage{
beamGLForces(beamP, beamT, Y, MoI, Length, GMat, BUDL, BND)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{Y}{Elastic Modulus of material}

\item{MoI}{Moment of Inertia}

\item{Length}{Length of beam}

\item{GMat}{Global stiffness matrix}

\item{BUDL}{Column matrix for beam distributed load}

\item{BND}{beam nodal displacement, output from function "beamNodeDis"}
}
\value{
Matrices of global and local forces. (Results in kN)
\item{GForce}{Large global force matrix.}
\item{Lforce}{Large local force matrix.}
}
\description{
Uses nodal displacements to determine global and local forces at each node
}
\examples{
data(beamGeo)
data(beamDime)
data(beamsUDL)
data(beamND)
data(beamGloMat)

Length = beamDime$Length
MoI = beamDime$MomentofInertia
BUDL = beamsUDL
BND = beamND
GMat = beamGloMat

GLforce = beamGLForces(beamGeo$beamP, beamGeo$beamT, beamGeo$Y, MoI, Length, GMat, BUDL, BND)

}
