% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.oneway}
\alias{average.power.oneway}
\title{Compute average power of many one-way ANOVA tests}
\usage{
average.power.oneway(n, alpha, theta, k)
}
\arguments{
\item{n}{per-group sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{theta}{sum of ((group mean - overall mean)/stdev)^2 across all groups for each hypothesis test(vector)}

\item{k}{the number of groups to be compared}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of many one-way ANOVA tests
}
\examples{
theta=rep(c(2,0),c(100,900));
average.power.oneway(n = 50, alpha = 0.05, theta = theta, k = 2)
}
\seealso{
\code{\link{power.oneway}} for more details about power calculation of one-way ANOVA
}
