% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.fdr.R
\name{p.fdr}
\alias{p.fdr}
\title{FDR Computation}
\usage{
p.fdr(
  pvalues = NA,
  zvalues = "two.sided",
  threshold = 0.05,
  adjust.method = "BH",
  BY.corr = "positive",
  just.fdr = FALSE,
  default.odds = 1,
  estim.method = "set.pi0",
  set.pi0 = 1,
  hist.breaks = "scott",
  ties.method = "random",
  sort.results = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{pvalues}{A numeric vector of raw p-values.}

\item{zvalues}{A numeric vector of z-values to be used in pi0 estimation or a string with options "two.sided", "greater" or "less". Defaults to "two.sided".}

\item{threshold}{A numeric value in the interval \code{[0,1]} used in a multiple comparison hypothesis tests to determine significance from the null. Defaults to 0.05.}

\item{adjust.method}{A string used to identify the p-value and false discovery rate adjustment method. Defaults to \code{BH}. Options are \code{BH}, \code{BY}, code{Bon},\code{Holm}, \code{Hoch}, and \code{Sidak}.}

\item{BY.corr}{A string of either "positive" or "negative" to determine which correlation is used in the BY method. Defaults to \code{positive}.}

\item{just.fdr}{A Boolean TRUE or FALSE value which output only the FDR vector instead of the list output. Defaults to FALSE.}

\item{default.odds}{A numeric value determining the ratio of pi1/pi0 used in the computation of one FDR. Defaults to 1.}

\item{estim.method}{A string used to determine which method is used to estimate the null proportion or pi0 value. Defaults to \code{set.pi0}.}

\item{set.pi0}{A numeric value to specify a known or assumed pi0 value in the interval \code{[0,1]}. Defaults to 1. Which means the assumption is that all inputted raw p-values come from the null distribution.}

\item{hist.breaks}{A numeric or string variable representing how many breaks are used in the pi0 estimation histogram methods. Defaults to "scott".}

\item{ties.method}{A string a character string specifying how ties are treated. Options are "first", "last", "average", "min", "max", or "random". Defaults to "random".}

\item{sort.results}{A Boolean TRUE or FALSE value which sorts the output in either increasing or non-increasing order dependent on the FDR vector. Defaults to FALSE.}

\item{na.rm}{A Boolean TRUE or FALSE value indicating whether NA's should be removed from the inputted raw p-value vector before further computation. Defaults to TRUE.}
}
\value{
A list containing the following components:

\item{fdrs}{A numeric vector of method adjusted FDRs.}

\item{Results Matrix}{A numeric matrix of method adjusted FDRs, method adjusted p-values, and raw p-values.}

\item{Reject Vector}{A vector containing Reject.H0 and/or FTR.H0 based off of the threshold value and hypothesis test on the adjusted p-values.}

\item{pi0}{A numeric value for the pi0 value used in the computations. }

\item{threshold}{A numeric value for the threshold value used in the hypothesis tests.}

\item{Adjustment Method}{The string with the method name used in computation(needed for the plot.fdr function).}
}
\description{
This function computes FDRs and Method Adjusted p-values.
}
\details{
We run into errors or warnings when pvalues, zvalues, threshold, set.pi0, BY.corr, or default.odds are not inputted correctly.
}
\examples{

# Example 1
pi0 = 0.8
pi1 = 1-pi0
n = 10000
n.0 = ceiling(n*pi0)
n.1 = n-n.0

sim.data = c(rnorm(n.1,3,1),rnorm(n.0,0,1))
sim.data.p = 2*pnorm(-abs(sim.data))

fdr.output = p.fdr(pvalues=sim.data.p, adjust.method="BH")

fdr.output$fdrs
fdr.output$pi0

# Example 2

sim.data.p = output = c(runif(800),runif(200, min=0, max=0.01))
fdr.output = p.fdr(pvalues=sim.data.p, adjust.method="Holm", sort.results = TRUE)

fdr.output$`Results Matrix`

}
\references{
\insertRef{Rpack:bibtex}{Rdpack}

\insertRef{R}{FDRestimation}

\insertRef{efron:2013}{FDRestimation}

\insertRef{bh:1995}{FDRestimation}

\insertRef{shaffer:1995}{FDRestimation}

\insertRef{storey:2003}{FDRestimation}

\insertRef{by:2001}{FDRestimation}

\insertRef{mein:2006}{FDRestimation}

\insertRef{jiang:2008}{FDRestimation}

\insertRef{nett:2006}{FDRestimation}

\insertRef{pounds:2003}{FDRestimation}

\insertRef{holm:1979}{FDRestimation}

\insertRef{bon:1936}{FDRestimation}

\insertRef{hoch:1988}{FDRestimation}

\insertRef{sidak:1967}{FDRestimation}

\insertRef{murray2020false}{FDRestimation}
}
\seealso{
\code{\link{plot.p.fdr}, \link{summary.p.fdr}, \link{get.pi0}}
}
\concept{FDR adjusted p-values null proportion}
\keyword{FDR}
\keyword{p-values}
