
limit_coeffs <- \(n) {
    pd <- prod(n)
    rho <- pd / sum(pd / n)
    delta <- rho / n
    list(rho = rho, delta = delta)
}

get_n <- \(samplemat) {
    rowSums(samplemat)
}

get_mu <- \(samplemat, n) {
    sweep(samplemat, 1, n, "/")
}

get_s <- \(L) {
    rep(attr(L, "scaling"), times = attr(L, "size"))
}
