% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_aux.R
\name{FCVARsim}
\alias{FCVARsim}
\title{Draw Samples from the FCVAR Model}
\usage{
FCVARsim(x, model, NumPeriods)
}
\arguments{
\item{x}{A \eqn{N x p} matrix of \code{N} starting values for the simulated observations.}

\item{model}{A list of estimation results, just as if estimated from \code{FCVARest}.
The parameters in \code{model} can also be set or adjusted by assigning new values.}

\item{NumPeriods}{The number of time periods in the simulation.}
}
\value{
A \code{NumPeriods} by \eqn{p} matrix \code{xBS} of simulated observations.
}
\description{
\code{FCVARsim} simulates the FCVAR model as specified by
input \code{model} and starting values specified by \code{data}.
Errors are drawn from a normal distribution.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
x_sim <- FCVARsim(x[1:10, ], results, NumPeriods = 100)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} for the specification of the \code{model}.
Use \code{FCVARsim} to draw a sample from the FCVAR model.
For simulations intended for bootstrapping statistics, use \code{FCVARsimBS}.

Other FCVAR auxiliary functions: 
\code{\link{FCVARforecast}()},
\code{\link{FCVARlikeGrid}()},
\code{\link{FCVARsimBS}()},
\code{\link{FracDiff}()},
\code{\link{plot.FCVAR_grid}()}
}
\concept{FCVAR auxiliary functions}
