% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFBCRMSimTrial.R
\name{MFBCRMSimTrial}
\alias{MFBCRMSimTrial}
\title{Provides simulation results using MFBCRM}
\usage{
MFBCRMSimTrial(max_samp, Cohort, ptrue, mu_mat, p_rho, sigma, mtd, p_u, B, M)
}
\arguments{
\item{max_samp}{Total number of patients recruited/will be recruited in the trial.}

\item{Cohort}{Number of patients within each cohort.}

\item{ptrue}{True toxicity probability vector.}

\item{mu_mat}{Prior expected toxicity probability matrix at each dose.}

\item{p_rho}{Prior probability that two dose-toxicity probabilities will not cluster together.}

\item{sigma}{Prior standard deviation for the parameter alpha.}

\item{mtd}{Maximum Tolerated dose toxicity probability (pre defined).}

\item{p_u}{Cut-off toxicity probability for first dose.}

\item{B}{Number of Iterations to run for MCMC.}

\item{M}{Number of simulations to run.}
}
\value{
A list containing (1) Design parameters and prior hyperparameters used for simulating the trials and (2) a summary of the trial simulation results including the percent of times each dose was selected and the average number of toxicities seen in the trial.
}
\description{
Provides simulation results using MFBCRM
}
\examples{
max_samp=15   ##Change to larger size
Cohort=3
ptrue=c(0.01,0.05,0.15,0.3,0.45,0.5,0.6,0.8)
##Skeletons for 8 doses
mu1=c(0.02,0.06,0.08,0.12,0.2,0.3,0.4,0.5)
mu2=c(0.01,0.05,0.09,0.14,0.18,0.22,0.26,0.30)
mu3=c(0.10,0.20,0.30,0.40,0.50,0.60,0.70,0.80)
mu4=c(0.20,0.30,0.40,0.50,0.60,0.65,0.70,0.75)
mu_mat=matrix(c(mu1,mu2,mu3,mu4),nrow = 4,byrow = TRUE)
p_rho=0.9
sigma = 2
mtd = 0.3
p_u=0.9
B=200 ##Number of iterations, change to 2k
M=10 ##Number of simulations, change to larger
Z=MFBCRMSimTrial(max_samp,Cohort,ptrue,mu_mat,p_rho,sigma,mtd,p_u,B,M)
Z
}
