% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMFBCRM.R
\name{GetMFBCRM}
\alias{GetMFBCRM}
\title{Provides the optimal dose level closest to the mtd where the next cohort of patients should be allotted based on the data}
\usage{
GetMFBCRM(X, Y, Cohort, mu_mat, p_rho, sigma, mtd, B, p_u)
}
\arguments{
\item{X}{Vector of patients allotted to each dose level .}

\item{Y}{Vector of toxicity events in each dose.}

\item{Cohort}{Number of patients within each cohort.}

\item{mu_mat}{Prior expected toxicity probability matrix at each dose.}

\item{p_rho}{Prior probability that two dose-toxicity probabilities will not cluster together.}

\item{sigma}{Prior standard deviation for the parameter alpha.}

\item{mtd}{Maximum Tolerated dose toxicity probability (pre defined).}

\item{B}{Number of Iterations to run for MCMC.}

\item{p_u}{Cut-off toxicity probability for first dose}
}
\value{
A list containing (1) Design parameters and prior hyperparameters used for running the trials and (2) a posterior summary of the resuls, including the next dose to assign patients to.
}
\description{
Provides the optimal dose level closest to the mtd where the next cohort of patients should be allotted based on the data
}
\examples{
X=c(3, 6, 3, 3, 3, 9, 15, 6)
Y=c(1, 0, 1, 0, 0, 2,  4, 5)
Cohort=3
##Skeletons for 8 doses
mu1=c(0.02,0.06,0.08,0.12,0.2,0.3,0.4,0.5)
mu2=c(0.01,0.05,0.09,0.14,0.18,0.22,0.26,0.30)
mu3=c(0.10,0.20,0.30,0.40,0.50,0.60,0.70,0.80)
mu4=c(0.20,0.30,0.40,0.50,0.60,0.65,0.70,0.75)
mu_mat=matrix(c(mu1,mu2,mu3,mu4),nrow = 4,byrow = TRUE)
p_rho=0.9
sigma = 2
mtd = 0.3
B=2000 ##Number of iterations
p_u=0.9
Z=GetMFBCRM(X, Y, Cohort, mu_mat, p_rho, sigma, mtd, B, p_u)
Z
}
