% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBCRMSimTrial.R
\name{FBCRMSimTrial}
\alias{FBCRMSimTrial}
\title{Provides simulation results using FBCRM}
\usage{
FBCRMSimTrial(max_samp, Cohort, ptrue, mu, p_rho, sigma, mtd, p_u, B, M)
}
\arguments{
\item{max_samp}{Total number of patients recruited/will be recruited in the trial.}

\item{Cohort}{Number of patients within each cohort.}

\item{ptrue}{True toxicity probability vector.}

\item{mu}{Prior expected toxicity probability at each dose.}

\item{p_rho}{Prior probability that two dose-toxicity probabilities will not cluster together.}

\item{sigma}{Prior standard deviation for the parameter alpha.}

\item{mtd}{Maximum Tolerated dose toxicity probability (pre defined).}

\item{p_u}{Cut-off toxicity probability for first dose.}

\item{B}{Number of Iterations to run for MCMC.}

\item{M}{Number of simulations to run.}
}
\value{
A list containing (1) Design parameters and prior hyperparameters used for simulating the trials and (2) a summary of the trial simulation results including the percent of times each dose was selected and the average number of toxicities seen in the trial.
}
\description{
Provides simulation results using FBCRM
}
\examples{
max_samp=15
Cohort=3
ptrue=c(0.01,0.05,0.15,0.3,0.45,0.5,0.6,0.8)
mu=seq(0.1,0.8,0.1)
p_rho=0.9
sigma = 2
mtd = 0.3
p_u=0.9
B=200 ##Number of iterations, Change to 2k
M=10 ##Number of simulations, Change to larger
Z=FBCRMSimTrial(max_samp,Cohort,ptrue,mu,p_rho,sigma,mtd,p_u,B,M)
Z
}
