% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_fava.R
\name{window_plot}
\alias{window_plot}
\title{Generate a plot of FAVA in sliding windows.}
\usage{
window_plot(window_fava, alpha = 0.5)
}
\arguments{
\item{window_fava}{The output of \code{window_fava}.}

\item{alpha}{Optional; number between 0 and 1 specifying the opacity of the horizontal
lines plotted. Default is \code{alpha = 0.5}.}
}
\value{
A ggplot2 object.
}
\description{
This function generates a plot of normalized or unnormalized, weighted or
unweighted FAVA computed in sliding windows across samples for one or many
groups of samples.
}
\examples{
A = matrix(c(.3,.7,0,.1,0,.9,.2,.5,.3,.1,.8,.1,.3,.4,.3,.6,.4,0,0,.5,.5),
           ncol = 3, byrow = TRUE)
window_out = window_fava(relab_matrix = A, window_size = 4, normalized = TRUE)
window_out$window_data
window_out$window_plot
}
