% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{SatVP}
\alias{SatVP}
\title{Saturation Vapour Pressure at a specific Air Temperature (e0T)}
\usage{
SatVP(Temp)
}
\arguments{
\item{Temp}{A numeric scalar that denotes the air temperature [C].}
}
\value{
The function returns the value of the saturation vapour pressure at the air temperature \code{Temp} [kPa] as a numeric scalar.
}
\description{
\code{SatVP} returns the value of saturation vapour pressure at the air temperature \code{Temp} [kPa].
}
\details{
This is a function to calculate the saturation vapour pressure at the air temperature \code{Temp} [kPa].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
SatVP(Temp = 25)

}
\seealso{
\code{\link{MSVP}}.
}
