% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VapPres.R
\name{MeanTemp}
\alias{MeanTemp}
\title{Mean Daily Air Temperature (T_mean)}
\usage{
MeanTemp(T_min, T_max)
}
\arguments{
\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}

\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}
}
\value{
The function returns the value of the mean daily air temperature [C] as a numeric scalar.
}
\description{
\code{MeanTemp} returns the value of mean daily air temperature [C].
}
\details{
This is a function to calculate the mean daily air temperature [C].
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
MeanTemp(T_min = 5, T_max = 35)

}
\seealso{
\code{\link{AtmPres}}.
}
