% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibull.R
\name{Weibull}
\alias{Weibull}
\alias{dWeibull}
\alias{pWeibull}
\alias{qWeibull}
\alias{rWeibull}
\alias{eWeibull}
\alias{lWeibull}
\title{The Weibull Distribution.}
\usage{
dWeibull(x, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

pWeibull(q, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

qWeibull(p, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

rWeibull(n, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

eWeibull(X, w, method = c("numerical.MLE", "moments"), ...)

lWeibull(
  X,
  w,
  shape = 2,
  scale = 2,
  params = list(shape = 2, scale = 2),
  logL = TRUE
)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{shape}{Shape parameter.}

\item{scale}{Scale parameter.}

\item{params}{A list that includes all named parameters}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{...}{Additional parameters.}

\item{logL}{logical; if TRUE, lWeibull gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dWeibull gives the density, pWeibull the distribution function,
qWeibull the quantile function, rWeibull generates random deviates, and
eWeibull estimates the distribution parameters. lWeibull provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the Weibull distribution with parameters \code{shape} and
\code{scale}. Parameter estimation can be based on a weighted or unweighted i.i.d sample and can be carried out analytically
or numerically.
}
\details{
The Weibull distribution is a special case of the generalised gamma distribution. The \code{dWeibull()}, \code{pWeibull()},
\code{qWeibull()},and \code{rWeibull()} functions serve as wrappers of the standard \code{\link[stats]{dweibull}},
\code{\link[stats]{pweibull}}, \code{\link[stats]{qweibull}}, and \code{\link[stats]{rweibull}} functions with
in the \pkg{\link{stats}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The Weibull distribution with parameters \code{shape}=\eqn{a} and \code{scale}=\eqn{b} has probability density function,
\deqn{f(x)= (a/b)(x/b)^{a-1}exp(-(x/b)^a)}
for \eqn{x >0}. Parameter estimation can be carried out using the method of moments as done by Winston (2003) or by numerical
maximum likelihood estimation.\cr
\cr
The log-likelihood function of the Weibull distribution is given by
\deqn{l(a,b|x) = n(ln a - ln b) + (a-1)\sum ln(xi/b) - \sum(xi/b)^{a}}
The score function and information matrix are as given by Rinne (p.412).
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rWeibull(n=1000, params=list(shape=1.5, scale=0.5))
est.par <- eWeibull(X=X, method="numerical.MLE"); est.par
plot(est.par)

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dWeibull(den.x,shape=est.par$shape,scale=est.par$scale)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)   # Original data
lines(density(X), lty=2)                 # Fitted curve

# Extracting shape and scale parameters
est.par[attributes(est.par)$par.type=="shape"]
est.par[attributes(est.par)$par.type=="scale"]

# Parameter Estimation for a distribution with unknown shape parameters
# Example from: Rinne (2009) Dataset p.338 and example pp.418-419
# Parameter estimates are given as shape = 2.5957 and scale = 99.2079.
data <- c(35,38,42,56,58,61,63,76,81,83,86,90,99,104,113,114,117,119,141,183)
est.par <- eWeibull(X=data, method="numerical.MLE"); est.par
plot(est.par)

# log-likelihood function
lWeibull(data, param = est.par)

# evaluate the precision of estimation by Hessian matrix
H <- attributes(est.par)$nll.hessian
var <- solve(H)
se <- sqrt(diag(var));se
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 1, chapter 21, Wiley, New York.\cr
 \cr
 Rinne, H. (2009) The Weibull Distribution A Handbook, chapter 11, Chapman & Hall/CRC.\cr
 \cr
 Winston, W.L (2003) Operations Research: Applications and algorithms, 4th Ed, Duxbury.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey. \cr
Updates and bug fixes by Sarah Pirikahu, Oleksii Nikolaienko.
}
