% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_overshadow.R
\name{check_overshadow}
\alias{check_overshadow}
\title{Check Overshadow - Pareto Dominate Solutions}
\usage{
check_overshadow(choice_sets)
}
\arguments{
\item{choice_sets}{An object of the choiceset class made by one of the DCE methods.}
}
\value{
A matrix of logicals indicating which if any card for a given row is Pareto dominate.
}
\description{
Check Overshadow - Pareto Dominate Solutions
}
\examples{
#See Step 7 of the Practical Introduction to ExpertChoice Vignette.
# Step 1
attrshort  = list(condition = c("0", "1", "2"),
technical =c("0", "1", "2"),
provenance = c("0", "1"))

#Step 2
#' # ff stands for "full fatorial"
 ff  <-  full_factorial(attrshort)
 af  <-  augment_levels(ff)
# af stands for "augmented factorial"

# Step 3
# Choose a design type: Federov or Orthogonal. Here an Orthogonal one is used.
nlevels <- unlist(purrr::map(ff, function(x){length(levels(x))}))
fractional_factorial <- DoE.base::oa.design(nlevels = nlevels, columns = "min34")

# Step 4 & 5
# The functional draws out the rows from the original augmented full factorial design.
colnames(fractional_factorial) <- colnames(ff)
fractional <- search_design(ff, fractional_factorial)
# Step 5 - Skipped, but important, see vignette.

# Step 6
# Two modulators c(1,1,1) and c(0,1,1) are specified.
dce_modulo <- modulo_method(
fractional,
list(c(1,1,1),c(0,1,1))
)

# Step 7! -- Check for Pareto dominate solutions
check_overshadow(dce_modulo)
}
