% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombetukey.R
\name{anscombetukey}
\alias{anscombetukey}
\title{Test for homogeneity of variances of Anscombe and Tukey}
\usage{
anscombetukey(
  resp,
  Trat,
  Bloco,
  glres,
  msres,
  sstrat,
  ssbloco,
  residuals,
  fitted.values
)
}
\arguments{
\item{resp}{Numeric or complex vector containing the response
variable.}

\item{Trat}{Numeric or complex vector containing the
treatments.}

\item{Bloco}{Numeric or complex vector containing the blocks.}

\item{glres}{Residual degrees of freedom.}

\item{msres}{Residual Mean Square.}

\item{sstrat}{Residual Sum of Squares.}

\item{ssbloco}{Sum of Squares for blocks.}

\item{residuals}{Numeric or complex vector containing the
residuals.}

\item{fitted.values}{Numeric or complex vector containing the
fitted values.}
}
\value{
Returns the p-value of Anscombe and Tukey's test of
homogeneity of variances and its practical interpretation for
5\% of significance.
}
\description{
\code{anscombetukey} Performs the test for homogeneity of
 variances of Anscombe and Tukey (1963).
}
\examples{
data(ex2)
attach(ex2)
rbd(trat, provador, aparencia, quali = TRUE, mcomp = "tukey",
hvar='anscombetukey', sigT = 0.05, sigF = 0.05)
}
\references{
ANSCOMBE, F. J.; TUKEY, J. W. \emph{The
examination and analysis of residuals.} Technometrics,
5:141-160, 1963.

RIBEIRO, R. \emph{Proposta e comparacao do desempenho de
testes para homogeneidade de variancia de modelos de
classificacao one-way e two-way}. Iniciacao Cientifica.
(Iniciacao Cientifica) - Universidade Federal de Alfenas.
2012.
}
\seealso{
\code{\link{han}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira, \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Marcos Costa de Paula

Mateus Pimenta Siqueira Lima
}
