% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Smith.R
\name{Smith}
\alias{Smith}
\title{Smith dynamic}
\usage{
Smith(time, state, parameters)
}
\arguments{
\item{time}{Regular sequence that represents the time sequence under which
simulation takes place.}

\item{state}{Numeric vector that represents the initial state.}

\item{parameters}{Numeric vector that represents parameters needed by the
dynamic.}
}
\value{
Numeric list. Each component represents the rate of change depending on
 the dynamic.
}
\description{
Smith dynamic as a type of evolutionary dynamics.
}
\examples{
dynamic <- Smith
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3), 1, 3, byrow=TRUE)
phaseDiagram3S(A, dynamic, NULL, state, FALSE, FALSE)
}
\references{
Smith, M. J. (1984)
"The Stability of a Dynamic Model of Traffic Assignment -- 
 An Application of a Method of Lyapunov",
 Transportation Science 18, pp. 245--252.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
