% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNN.R
\name{BNN}
\alias{BNN}
\title{Brown-von Neumann-Nash dynamic}
\usage{
BNN(time, state, parameters)
}
\arguments{
\item{time}{Regular sequence that represents the time sequence under which
simulation takes place.}

\item{state}{Numeric vector that represents the initial state.}

\item{parameters}{Numeric vector that represents parameters needed by the
dynamic.}
}
\value{
Numeric list. Each component represents the rate of change depending on
 the dynamic.
}
\description{
Brown-von Neumann-Nash replicator dynamic as a type of
 evolutionary dynamics.
}
\examples{
dynamic <- BNN
A <- matrix(c(0, -2, 1, 1, 0, -2, -2, 1, 0), 3, byrow=TRUE)
state <- matrix(c(0.4, 0.3, 0.3), 1, 3, byrow=TRUE)
phaseDiagram3S(A, dynamic, NULL, state, FALSE, FALSE)
}
\references{
Brown, G. W. and von Neumann, J. (1950) 
"Solutions of games by differential equations", In:
Kuhn, Harold William and Tucker, Albert William (Eds.) 
"Contributions to the Theory of Games I", 
Princeton University Press, pp. 73--79.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
