% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik_Chen_piecewise_exponential.R
\name{loglik_Chen_piecewise_exponential}
\alias{loglik_Chen_piecewise_exponential}
\title{Log-likelihood function for piecewise-exponential distribution with cured population}
\usage{
loglik_Chen_piecewise_exponential(par = NULL, df, piecewiseSurvivalTime)
}
\arguments{
\item{par}{a vector with m+1 elements, where the first element denotes the logistic of the proportion
of the cured population, and the rest element denotes the log of the hazard rate in intervals}

\item{df}{The subject-level event data, including \code{time}
and \code{event}.}

\item{piecewiseSurvivalTime}{A vector with length m that specifies the time
intervals for the piecewise exponential survival distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}
}
\value{
The negative value of the log-likelihood function given parameter
\code{par} and the dataset \code{df}
}
\description{
Provide log-likelihood function for piecewise-exponential distribution with cured population
}
\references{
\itemize{
\item Chen, Tai-Tsang. "Predicting analysis times in randomized clinical trials with cancer immunotherapy."
BMC medical research methodology 16.1 (2016): 1-10.
}
}
