% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climatch_par.R
\name{climatch_par}
\alias{climatch_par}
\title{Run climatch in parallel}
\usage{
climatch_par(recipient,

source,

globvar,

biovar = 1:length(globvar),

ncores,

type = "perc",

threshold = 6)
}
\arguments{
\item{recipient}{List of data.frames of the recipient regions}

\item{source}{List of dataf.rames of the source regions}

\item{globvar}{Vector of the global variance of each variable}

\item{biovar}{Vector of the columns (climate variables) to use, default all columns}

\item{ncores}{The number of cores to use in parallel}

\item{type}{Choose between "perc" (default) or "mean" passed to climatch_sum() and "vec" passes to climatch_vec()}

\item{threshold}{The climatch score (0-10) to use in calculating the percentage match, which is the number of grid cells within the recipient region with a climatch >= the threshold (default is 6).}
}
\value{
"perc" and "mean" returns data.frame of climatch within recipients (rows) for each source represented in columns, "vec" returns data.frame of climatch of a recipient (each column corresponds to grid cell), to sources (corresponding to rows)
}
\description{
Run climatch in parallel
}
\examples{
# Dummy data
i1 <- data.frame("clim1" = 1:10, "clim2" = 9:18) # Fake source climate data
i <- list(i1, i1) # list the source dataframes
j1 <- data.frame("clim1" = 11:20, "clim2" = 16:25) # Fake recipient climate data
j <- list(j1, j1) # list the recipient dataframes
variance <- c(60, 80) # Fake global variance

# Climate matching
climatch_par(recipient = j, source = i, globvar = variance, ncores = 1, type = "vec")
}
