% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{regional_runtimes}
\alias{regional_runtimes}
\title{Summarise Regional Runtimes}
\usage{
regional_runtimes(
  regional_output = NULL,
  target_folder = NULL,
  target_date = NULL,
  return_output = FALSE
)
}
\arguments{
\item{regional_output}{A list of output as produced by \code{\link[=regional_epinow]{regional_epinow()}}
and stored in the \code{regional} list.}

\item{target_folder}{Character string specifying where to save results (will
create if not present).}

\item{target_date}{A character string giving the target date for which to
extract results
(in the format "yyyy-mm-dd"). Defaults to latest available estimates.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned,
this automatically updates to TRUE if no directory for saving is specified.}
}
\value{
A data.table of region run times
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Used internally by \code{regional_epinow} to summarise region run times.
}
\examples{
regional_out <- readRDS(system.file(
  package = "EpiNow2", "extdata", "example_regional_epinow.rds"
))
regional_runtimes(regional_output = regional_out$regional)
}
\seealso{
regional_summary regional_epinow
}
\keyword{internal}
