% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_stan_data}
\alias{create_stan_data}
\title{Create Stan Data Required for estimate_infections}
\usage{
create_stan_data(
  data,
  seeding_time,
  rt,
  gp,
  obs,
  backcalc,
  shifted_cases,
  forecast
)
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally
this can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument.}

\item{seeding_time}{Integer; seeding time, usually obtained using
\code{\link[=get_seeding_time]{get_seeding_time()}}.}

\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}

\item{gp}{A list of options as generated by \code{\link[=gp_opts]{gp_opts()}} to define the
Gaussian process. Defaults to \code{\link[=gp_opts]{gp_opts()}}. Set to \code{NULL} to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{\link[=obs_opts]{obs_opts()}} defining the
observation model. Defaults to \code{\link[=obs_opts]{obs_opts()}}.}

\item{backcalc}{A list of options as generated by \code{\link[=backcalc_opts]{backcalc_opts()}} to
define the back calculation. Defaults to \code{\link[=backcalc_opts]{backcalc_opts()}}.}

\item{shifted_cases}{A \verb{<data.frame>} of delay shifted cases}

\item{forecast}{A list of options as generated by \code{\link[=forecast_opts]{forecast_opts()}} defining
the forecast opitions. Defaults to \code{\link[=forecast_opts]{forecast_opts()}}. If NULL then no
forecasting will be done.}
}
\value{
A list of stan data
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Takes the output of \code{\link[=stan_opts]{stan_opts()}} and converts it into a list understood by
stan. Internally calls the other \code{create_} family of functions to
construct a single list for input into stan with all data required
present.
}
\examples{
\dontrun{
create_stan_data(
  example_confirmed, 7, rt_opts(), gp_opts(), obs_opts(), 7,
  backcalc_opts(), create_shifted_cases(example_confirmed, 7, 14, 7)
)
}
}
\keyword{internal}
