% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.init.R
\name{overwrite_attrs}
\alias{overwrite_attrs}
\title{Helper to use a \code{data.frame} to initialize some attributes}
\usage{
overwrite_attrs(dat)
}
\arguments{
\item{dat}{Main \code{netsim_dat} object containing a \code{networkDynamic}
object and other initialization information passed from
\code{\link{netsim}}.}
}
\value{
The updated \code{netsim_dat} main list object.
}
\description{
Uses \code{dat$init$init_attr} to overwrite some attributes of the
nodes at initialization
}
\details{
If an \code{init_attr} \code{data.frame} is present in \code{dat$init}, use it to overwrite
the attributes it contains.
\code{init_attr} must have a number of rows equal to the number of nodes in the
model as the attributes will be overwritten one to one, ensuring the correct
ordering.
\code{init_attr} columns MUST have a corresponding attribute already initialized.
See "R/default_attributes.R" for adding new attributes to the model.
\code{init_attr} is removed from \code{dat$init} at the end of the function to free up
its memory.
}
