% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envcoding.R
\name{otu.space}
\alias{otu.space}
\title{Compute the Matrix Representing the Species Vector Subspace}
\usage{
otu.space(data, r = 10, aa = "all", silent = TRUE)
}
\arguments{
\item{data}{input data must be a dataframe (see details).}

\item{r}{a positive integer indicating the radius of the sequence segment considered as environment.}

\item{aa}{the amino acid(s) to be used to encoded the species.}

\item{silent}{logical. If FALSE, the running progress is reported.}
}
\value{
A matrix representing the species vector subspace.
}
\description{
Computes the matrix representing the species vector subspace.
}
\details{
Input data must be a dataframe where each row corresponds to an individual protein, and each column identifies a species. Therefore, the columns' names of this dataframe must be coherent with the names of the OTUs being analyzed. The dimension of the vector representing each species will depend on the settings. For instance, if we choose a single amino acid and a radius of 10 for the sequence environment, then we will get a vector of dimension 400 (20 amino acids x 20 positions). If we opt for the 20 amino acids and r = 10, then the vector will be of dimension 8000 (400 for each amino acid * 20 amino acids). Please, note that r is selected in the function env.sp() that will provide the input dataframe for the current function.
}
\examples{
data(bovids)
otu.space(bovids[, 1:5], r = 2)
}
\seealso{
env.sp(), otu.vector()
}
