% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdnj.R
\name{ncd}
\alias{ncd}
\title{Compute Normalized Compression Distances}
\usage{
ncd(seq1, seq2)
}
\arguments{
\item{seq1}{character string indicating the path to the first fasta file to be analyzed.}

\item{seq2}{character string indicating the path to the second fasta file to be analyzed.}
}
\value{
A non-negative real value reflecting the dissimilarity between seq1 and seq2.
}
\description{
Computes normalized compression distances.
}
\details{
The two fasta files must be in the working directory. This function use zpaq to compress files. Thus, the zpaq software must be installed on your system and in the search path for executables if you wish to use this function.
NCD = (Z(xy) - min(Z(x), Z(y))) / max(Z(x), Z(y))
Where Z(x), Z(y) and Z(xy) are the lengths of the compressed versions of seq1, seq2 and the concatenated sequences 1 and 2, respectively.
}
\examples{
\donttest{try(ncd(seq1 = "./A.fasta", seq2 = "./B.fasta"))}
}
\seealso{
ncdnj()
}
