% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cashflow.R
\name{cashflow}
\alias{cashflow}
\title{Calculate present value and annual value from a given future payments of cash flows

\code{cashflow} Compute a given cash flow data's present value and annual value.
The first column is the cash flow year;the rest is the cash flow money.
The number of rows is the lifespan}
\usage{
cashflow(i, cashflowdata)
}
\arguments{
\item{i}{annual interest rate in percentage}

\item{cashflowdata}{cash flow data containing the life span and money value of the cash flow for each year}
}
\value{
cash.flow.table
}
\description{
Calculate present value and annual value from a given future payments of cash flows

\code{cashflow} Compute a given cash flow data's present value and annual value.
The first column is the cash flow year;the rest is the cash flow money.
The number of rows is the lifespan
}
\examples{
# Result : cash.flow.table  
# Result : future value = 232540.78
# Result : present value = 206330.96   
year = c(1:5)             
capital = c(63000,1300,1300,1600,1300)
year1 = c(60000,0,10000,0,0)
year2 = c(0,0,30000,50000,0)
cashflowdata <- data.frame (year, capital, year1, year2)
cashflow(0.055, cashflowdata)
}
