% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual_to_present.R
\name{annual_to_present}
\alias{annual_to_present}
\title{Calculate present value from a uniform annual payment

\code{annual_to_present} Compute present value from uniform annual payments
using uniform series present worth factor (uswf)}
\usage{
annual_to_present(i, n, A)
}
\arguments{
\item{i}{discount rate in percent per year}

\item{n}{life span in years}

\item{A}{series of uniform annual payments}
}
\value{
pr.value
}
\description{
Calculate present value from a uniform annual payment

\code{annual_to_present} Compute present value from uniform annual payments
using uniform series present worth factor (uswf)
}
\examples{
 
# Result: pr.value = $337733.5
annual_to_present(0.08, 30, 30000)  

}
\references{
Newnan, D. G., Eschenbach, T. G., Lavelle, J. P., & Oxford, N. Y.
Engineering Economic Analysis, 14th ed.
New York, Oxford University Press, 2020

David, W., & Terry, R.
Fundamentals of Engineering Economics and Decision Analysis.
Springer Nature, 2012
}
