% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__BAT.R
\name{config_bat}
\alias{config_bat}
\title{Configuration object for the Bat Algorithm}
\usage{
config_bat(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  initial_loudness = 1.5,
  alpha = 0.9,
  initial_pulse_rate = 0.5,
  gamma = 0.9,
  freq_min = 0,
  freq_max = 2
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of bats.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{initial_loudness}{initial loudness of emitted pulses. Typical values are in the range [1, 2]. Default is \code{1.5}.}

\item{alpha}{parameter to control the linearly decreasing loudness with
the iterations. It should be between 0 and 1. Default is \code{0.9}.}

\item{initial_pulse_rate}{initial rate at which pulses are emitted. It should
be between 0 and 1. Default is \code{0.5}.}

\item{gamma}{parameter to control the exponentially decreasing pulse rate with
the iterations. Defatul is \code{0.9}.}

\item{freq_min}{minimum frequency value of pulses. Default is \code{0}.}

\item{freq_max}{maximum frequency value of pulses. Default is \code{2.0}.}
}
\value{
\code{config_bat} returns an object of class \code{BATConfig}.
}
\description{
Create a configuration object for the Bat Algorithm (BAT). At minimum the number of iterations
(parameter \code{iterations}) and the number of bats (parameter \code{population_size}) have
to be provided.
}
\examples{
conf <- config_bat(iterations = 100, population_size = 50, iterations_same_cost = NULL,
absolute_tol = NULL, initial_loudness = 1.5, alpha = 0.9,
initial_pulse_rate = 0.5, gamma = 0.9,
freq_min = 0., freq_max = 2.)


}
\references{
\insertRef{yang2010new}{EmiR}
}
