% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Derivative.R
\name{ParCall}
\alias{ParCall}
\title{Parameters call}
\usage{
ParCall(
  Fun,
  n.,
  Temp.,
  Dx1.,
  eta.,
  exptime.,
  Eo1.,
  ko1.,
  ko2.,
  kc.,
  Dm.,
  Vf.,
  Vi.,
  Vs.,
  alpha1.,
  Eo2.,
  Dred1.,
  Dred2.,
  alpha2.,
  Dred3.,
  Dred4.,
  ko3.,
  ko4.,
  kco.,
  kc1.,
  kc2.,
  kc3.,
  kc4.,
  alpha3.,
  alpha4.,
  Eo3.,
  Eo4.,
  l.
)
}
\arguments{
\item{Fun}{Name of the function this function is called to. Must be a string.}

\item{n.}{Number of electrons}

\item{Temp.}{Temperature for the simulation}

\item{Dx1.}{Diffusion coefficient of species One}

\item{eta.}{OverPotential for potential step}

\item{exptime.}{experimental time for the simulation}

\item{Eo1.}{reduction potential of the first electrochemical reaction}

\item{ko1.}{heterogeneous electron transfer rate constant of the first electrochemical reaction}

\item{ko2.}{heterogeneous electron transfer rate constant of the second electrochemical reaction}

\item{kc.}{Chemical rate constant for first Ox Species, used in simulation with just one species}

\item{Dm.}{Simulation parameter, maximum 0.5 for explicit methods}

\item{Vf.}{Final potential of the sweep}

\item{Vi.}{Initial potential of the sweep}

\item{Vs.}{Scan rate of the simulation}

\item{alpha1.}{charge transfer coefficient of the first electrochemical reaction}

\item{Eo2.}{reduction potential of the second electrochemical reaction}

\item{Dred1.}{diffusion coefficient of the first reduced species}

\item{Dred2.}{diffusion coefficient of the second reduced species}

\item{alpha2.}{charge transfer coefficient of the second electrochemical reaction}

\item{Dred3.}{diffusion coefficient of the third reduced species}

\item{Dred4.}{diffusion coefficient of the fourth reduced species}

\item{ko3.}{heterogeneous electron transfer rate constant of the third electrochemical reaction}

\item{ko4.}{heterogeneous electron transfer rate constant of the fourth electrochemical reaction}

\item{kco.}{Chemical rate constant for first Ox Species}

\item{kc1.}{Chemical rate constant for first Red Species}

\item{kc2.}{Chemical rate constant for second Red Species}

\item{kc3.}{Chemical rate constant for third Red Species}

\item{kc4.}{Chemical rate constant for fourth Red Species}

\item{alpha3.}{charge transfer coefficient of the third electrochemical reaction}

\item{alpha4.}{charge transfer coefficient of the fourth electrochemical reaction}

\item{Eo3.}{reduction potential of the third electrochemical reaction}

\item{Eo4.}{reduction potential of the fourth electrochemical reaction}

\item{l.}{numer of time steps}
}
\value{
inverse matrix of the selected
}
\description{
Returns a list with the parameters necessary for the simulation
}
\examples{
ParCall("ChronAmp", n. = 1, Temp. = 298, Dx1. = 0.0001, exptime. = 1, Dm. = 0.45, l. = 100)

}
