% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.r
\name{gini}
\alias{gini}
\title{Compute the Gini coefficient}
\usage{
gini(mat)
}
\arguments{
\item{mat}{A region-industry count matrix}
}
\value{
The Gini coefficient or a data frame with the Gini coefficient for each industry (if the input is a matrix with multiple columns)
}
\description{
This function computes the Gini coefficient. The Gini index measures spatial inequality. It ranges from 0 (perfect income equality) to 1 (perfect income inequality) and is derived from the Lorenz curve. The Gini coefficient is defined as a ratio of two surfaces derived from the Lorenz curve. The numerator is given by the area between the Lorenz curve of the distribution and the uniform distribution line (45 degrees line). The denominator is the area under the uniform distribution line (the lower triangle). This index gives an indication of the unequal distribution of an industry accross n regions. Maximum inequality in the sample occurs when n-1 regions have a score of zero and one region has a positive score. The maximum value of the Gini coefficient is (n-1)/n and approaches 1 (theoretical maximum limit) as the number of observations (regions) increases.
}
\examples{
## generate vectors of industrial count
ind <- c(0, 10, 10, 30, 50)

## run the function
gini(ind)

## generate a region - industry matrix
mat <- matrix(
  c(
    0, 1, 0, 0,
    0, 1, 0, 0,
    0, 1, 0, 0,
    0, 1, 0, 1,
    0, 1, 1, 1
  ),
  ncol = 4, byrow = TRUE
)
rownames(mat) <- c("R1", "R2", "R3", "R4", "R5")
colnames(mat) <- c("I1", "I2", "I3", "I4")

## run the function
gini(mat)

## run the function by aggregating all industries
gini(rowSums(mat))

## run the function for industry #1 only (perfect equality)
gini(mat[, 1])

## run the function for industry #2 only (perfect equality)
gini(mat[, 2])

## run the function for industry #3 only (perfect unequality: max gini = (5-1)/5)
gini(mat[, 3])

## run the function for industry #4 only (top 40\% produces 100\% of the output)
gini(mat[, 4])

}
\references{
Gini, C. (1921) Measurement of Inequality of Incomes, \emph{The Economic Journal} \strong{31}: 124-126
}
\seealso{
\code{\link{hoover_gini}}, \code{\link{locational_gini}}, \code{\link{locational_gini_curve}}, \code{\link{lorenz_curve}}, \code{\link{hoover_curve}}
}
\author{
Pierre-Alexandre Balland \email{p.balland@uu.nl}
}
\keyword{concentration}
\keyword{inequality}
