% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrepancyPrior-IndLTPrior-class.R,
%   R/DiscrepancyPrior-IndSTPrior-class.R,
%   R/DiscrepancyPrior-ShaSTPrior-class.R,
%   R/DiscrepancyPrior-TruthPrior-class.R, R/EnsemblePrior-class.R
\name{IndLTPrior}
\alias{IndLTPrior}
\alias{IndSTPrior}
\alias{ShaSTPrior}
\alias{TruthPrior}
\alias{EnsemblePrior}
\title{Constructor for the \code{EnsemblePrior} class}
\usage{
IndLTPrior(
  parametrisation_form = "lkj",
  var_params = list(1, 1),
  cor_params = 1
)

IndSTPrior(
  parametrisation_form = "hierarchical",
  var_params = list(-3, 1, 8, 4),
  cor_params = list(0.1, 0.1, 0.1, 0.1),
  AR_params = c(2, 2)
)

ShaSTPrior(
  parametrisation_form = "lkj",
  var_params = list(1, 10),
  cor_params = 1,
  AR_params = c(2, 2)
)

TruthPrior(
  d,
  initial_mean = 0,
  initial_var = 100,
  rw_covariance = list(2 * d, diag(d))
)

EnsemblePrior(
  d,
  ind_st_params = IndSTPrior(),
  ind_lt_params = IndLTPrior(),
  sha_st_params = ShaSTPrior(),
  sha_lt_params = 5,
  truth_params = TruthPrior(d)
)
}
\arguments{
\item{parametrisation_form}{The parametrisation by which the covariance matrix of the noise of the AR process (in the case of \code{IndSTPrior} and \code{ShaSTPrior} objects or the covariance of the distribution of long-term discrepancies for \code{IndLTPrior} objects) is decomposed. The default is \code{hierarchical} for \code{IndSTPrior} objects, and \code{lkj} otherwise. See details.}

\item{var_params}{The parameters characterising the variance of the AR process (in the case of \code{IndSTPrior} and \code{ShaSTPrior} objects or the variance of the distribution of long-term discrepancies for \code{IndLTPrior} objects) on the discrepancy. The default value is \code{list(-3, 1, 8, 4)} for \code{IndSTPrior} objects, \code{list(1, 1)} for \code{IndLTPrior} objects, and \code{list(1, 10)} for \code{ShaSTPrior} objects. See details.}

\item{cor_params}{The parameters characterising the correlations of the AR process (or the distribution of long-term discrepancies) on the short-term discrepancies. The default value in this case is to use \code{list(0.1,0.1,0.1,0.1)} for \code{IndSTPrior} objects, and \code{1} for \code{IndLTPrior} and \code{ShaSTPrior} objects. See details.}

\item{AR_params}{The parameters giving the beta parameters for the prior distribution on the autoregressive parameter of the AR(1) process. The default is \code{c(2,2)}. See details.}

\item{d}{A \code{numeric} specifying the number of variables of interest in the ensemble.}

\item{initial_mean}{A \code{numeric} giving the mean of the normal distribution giving the prior on the initial value of the random walk. This is the same value for each variable Default value is \code{0}.}

\item{initial_var}{A \code{numeric} giving the variance of the normal distribution giving the prior on the initial value of the random walk. This is the same value for each variable Default value is \code{100}.}

\item{rw_covariance}{A \code{list} of length \code{2} containing the inverse-Wishart parameters for the covariance of the random walk of the truth. The default value is \code{list(2*d, diag(d))}.}

\item{ind_st_params}{An \code{IndSTPrior} object specifying priors for the individual short-term discrepancies \eqn{z_k^{(t)}}. The default value is \code{IndSTPrior("hierarchical", list(-3, 1, 8, 4), list(0.1, 0.1, 0.1, 0.1), c(2, 2))}.}

\item{ind_lt_params}{An \code{IndLTPrior} object specifying priors for the individual long-term discrepancies \eqn{\gamma_k}. The default value is \code{IndLTPrior("lkj",list(1, 1), 1)}.}

\item{sha_st_params}{A \code{ShaSTPrior} object specifying priors for the shared short-term discrepancies \eqn{\eta^{(t)}}. The default value is \code{ShaSTPrior("lkj",list(1, 10), 1, c(2,2))}.}

\item{sha_lt_params}{A \code{numeric} of length \code{d} or \code{1} containing the standard deviations for the normal prior used on the shared short-term discrepancy \eqn{\mu}. If a single value is supplied,  this is repeated for each variable of interest. The default value is \code{5}.}

\item{truth_params}{A \code{TruthPrior} object specifying priors for the processes on the truth \eqn{y^{(t)}}. The default value is \code{TruthPrior(d)}.}
}
\value{
\code{EnsemblePrior} returns an object of class \code{EnsemblePrior}.
\code{IndSTPrior} returns an object of class \code{IndSTPrior}.
\code{IndLTPrior} returns an object of class \code{IndLTPrior}.
\code{ShaSTPrior} returns an object of class \code{ShaSTPrior}.
\code{TruthPrior} returns an object of class \code{TruthPrior}.
}
\description{
Constructors for the \code{EnsemblePrior} class and related classes. These functions are used to encode prior information for the ensemble model. The \code{IndSTPrior}, \code{IndLTPrior}, \code{ShaSTPrior}, and \code{TruthPrior} constructors encapsulate prior information.
}
\details{
\code{IndSTPrior} and \code{ShaSTPrior} discrepancy prior parameter objects contain 4 slots corresponding to:
\enumerate{
\item \code{parametrisation_form} - A \code{character} specifying how the priors are parametrised. Currently supported priors are \code{'lkj'}, \code{'inv_wishart'}, \code{'beta'}, \code{'hierarchical'}, or \code{'hierarchical_beta_conjugate'} (\code{'hierarchical'} and \code{'hierarchical_beta_conjugate'} are only supported for \code{IndSTPrior} objects).
\item \code{var_params} - The prior parameters for the discrepancy variances, either a \code{list} of length \code{2} or a \code{numeric} of length \code{4}. See below.
\item \code{cor_params} - The correlation matrix parameters, either a \code{list} of length \code{2}, a \code{numeric} of length \code{3} or a \code{numeric} of length \code{4}. See below.
\item \code{AR_params} - Parameters for the autoregressive parameter as a \code{numeric} of length \code{2}.
}

\code{IndLTPrior} discrepancy prior parameter objects contain the slots \code{parametrisation_form}, \code{var_params}, and \code{cor_params}.

There are currently five supported prior distributions on covariance matrices. As in Spence et. al. (2018), the individual and shared short-term discrepancy covariances, \eqn{\Lambda_k} and \eqn{\Lambda_\eta}, as well as the individual long-term discrepancy covariance, \eqn{\Lambda_\gamma},  are decomposed into a vector of variances and a correlation matrix \deqn{\Lambda = \sqrt{\mathrm{diag}(\pi)}  P \sqrt{\mathrm{diag}(\pi)},} where \eqn{\pi} is the vector of variances for each variable of interest (VoI), and \eqn{P} is the correlation matrix.

Selecting \code{'lkj'}, \code{'inv_wishart'}, \code{'beta'}, \code{'hierarchical'} or \code{'hierarchical_beta_conjugate'} refers to setting LKJ, inverse Wishart, beta or hierarchical (with gamma-distributed hyperparameters or beta-conjugate-distributed hyperparameters) prior distributions on the covariance matrix respectively. The variance parameters should be passed through as the \code{var_params} slot of the object and the correlation parameters should be passed through as the \code{cor_params}. For \code{'lkj'}, \code{'inv_wishart'}, and \code{'beta'} selections, variances are parameterised by gamma distributions, so the \code{var_params} slot should be a \code{list} of length two, where each element gives the shape and rate parameters for each VoI (either as a single value which is the same for each VoI or a \code{numeric} with the same length as the number of VoI). For example, setting \code{var_params  = list(c(5,6,7,8), c(4,3,2,1))} would correspond to a \code{Gamma(5, 4)} prior on the variance of the first VoI, a \code{Gamma(6, 3)} prior on the variance of the second VoI, etc...
The correlations should be in the following form:
\itemize{
\item If \code{'lkj'} is selected, then \code{cor_params} should be a \code{numeric} \eqn{\eta} giving the LKJ shape parameter, such  that the probability density is given by  (Lewandowski et. al. 2009) \deqn{f(\Sigma | \eta)\propto \mathrm{det} (\Sigma)^{\eta - 1}.} Variances are parameterised by gamma distributions.
\item If \code{'inv_wishart'} is selected, then  \code{cor_params} should be a \code{list} containing a scalar value \eqn{\eta} (giving the degrees of freedom) and a symmetric, positive definite matrix \eqn{S} (giving the scale matrix). The dimensions of \eqn{S} should be the same as the correlation matrix it produces (i.e \eqn{d \times d} where \eqn{d} is the number of VoI). The density of an inverse Wishart is given by  \deqn{f(W|\eta, S) = \frac{1}{2^{\eta d/2} \Gamma_N \left( \frac{\eta}{2} \right)} |S|^{\eta/2} |W|^{-(\eta + d + 1)/2}  \exp \left(- \frac{1}{2} \mathrm{tr}\left(SW^{-1} \right) \right),} where \eqn{\Gamma_N} is the multivariate gamma function and \eqn{\mathrm{tr \left(X \right)}} is the trace of \eqn{X}.  Note that inverse Wishart distributions act over the space of all covariance matrices. When used for a correlation  matrix, only the subset of valid covariance matrices that are also valid correlation matrices are considered. Variances are parameterised by gamma distributions.
\item If \code{'beta'} is selected, then  \code{cor_params} should be a  \code{list} containing two symmetric \code{d}\eqn{\times}\code{d} matrices \eqn{A} and \eqn{B} giving the prior success parameters and prior failure parameters respectively. The correlation between the \code{i}th and \code{j}th VoI is \eqn{\rho_{i, j}} with \deqn{\frac{1}{\pi} \tan^{-1} \frac{\rho_{i, j}}{\sqrt{1-\rho_{i, j}^2}} + \frac{1}{2} \sim \mathrm{beta}(A_{i, j}, B_{i, j}).} Variances are parameterised by gamma distributions.
\item If \code{'hierarchical'} or \code{'hierarchical_beta_conjugate'} is selected, then variances are parameterised by log-normal distributions:
\deqn{\log \pi_{k, i} \sim \mathrm{N}(\mu_i, \sigma^2_i)} with priors
\deqn{\mu_i \sim \mathrm{N}(\alpha_\pi, \beta_\pi),}
\deqn{\sigma^2_i \sim \mathrm{InvGamma}(\gamma_\pi, \delta_\pi).}
The \code{var_params} slot should then be a \code{numeric} of length 4, giving the \eqn{\alpha_\pi, \beta_\pi, \gamma_\pi, \delta_\pi} hyperparameters respectively. Correlations (\eqn{\rho_{k, i, j}} where \eqn{\rho_{k, i, j}} is the correlation between VoI \eqn{i} and \eqn{j} for the \eqn{k}th simulator) are parameterised by hierarchical beta distributions.
\deqn{\frac{\rho_{k, i, j} + 1}{2} \sim \mathrm{beta}(c_{k, i, j}, d_{k, i, j})} with priors
\deqn{c_{k, i, j} \sim \mathrm{gamma}(\alpha_\rho, \beta_\rho),}
\deqn{d_{k, i, j} \sim \mathrm{gamma}(\gamma_\rho, \delta_\rho).}
NOTE: These options is only supported for the individual short-term discrepancy terms.
\item If \code{'hierarchical'} is selected, then the \code{cor_params} slot should be a \code{numeric} of length 4 giving the \eqn{\alpha_\rho, \beta_\rho, \gamma_\rho, \delta_\rho} hyperparameters. respectively. NOTE: This option is only supported for the individual short-term discrepancy terms.
\item If \code{'hierarchical_beta_conjugate'} is selected, then the \code{cor_params} slot should be a \code{numeric} of length 3. Denoting the values by \eqn{r,s,k}, they map to the hyperparameters \eqn{p, q, k} of the beta conjugate distribution via \eqn{k = k}, \eqn{p^{-1/k} = (1+e^{-s})(1+e^{-r})} and \eqn{q^{1/k} = e^{-r}(1+e^{-s})^{-1}(1+e^{-r})^{-1}}. The density of the beta conjugate distribution is defined up to a constant of proportionality by
\deqn{p(\alpha_\rho, \beta_\rho\,|\,p, q, k) \propto \frac{\Gamma(\alpha_\rho + \beta_\rho)^{k}p^{\alpha_\rho}q^{\beta_\rho}}{\Gamma(\alpha_\rho)^{k}\Gamma(\beta_\rho)^{k}}\,.}
NOTE: This option is only supported for the individual short-term discrepancy terms.
Priors may also be specified for the autoregressive parameters for discrepancies modelled using autoregressive processes (i.e. for \code{IndSTPrior} and \code{ShaSTPrior} objects). These are parametrised via beta distributions such that the autoregressive parameter \eqn{R \in (-1,1)} satisfies \deqn{\frac{R+1}{2} \sim \mathrm{Beta}(\alpha, \beta)}.
}

In addition to priors on the discrepancy terms, it is also possible to add prior information on the truth. We require priors on the truth at \eqn{t=0}. By default, a \eqn{N(0, 10)} prior is used on the initial values., however this can be configured by the \code{truth_params} argument. The covariance matrix of the random walk of the truth \eqn{\Lambda_y} can be configured using an inverse-Wishart prior. The \code{truth_params} argument should be a \code{TruthPrior} object.
}
\examples{
##### Different forms of the individual long term discrepancy priors
#LKJ(10) priors on correlation matrices and gamma(5, 3) priors on the variances
ist_lkj <- IndSTPrior("lkj", list(5, 3), 10)#

#Same as above but with an additional beta(2, 4) prior on
#the autoregressive parameter of the AR process.
ist_lkj <- IndSTPrior("lkj", list(5, 3), 10, AR_params = c(2, 4))

#Same as above but with different variance priors for 5 different variables of interest.
#This encodes that there is a gamma(1, 1) prior on the variance of the first variable,
#a gamma(23, 1) on the second variable etc...
ist_lkj <- IndSTPrior("lkj", list(c(1,23,24,6,87), c(1,1,1,1,5)), 10, AR_params = c(2, 4))

#Hierarchical priors with gamma(1,2) and gamma(10, 1) on the variance hyperparameters and
#gamma(3,4), gamma(5,6) on the correlation hyperparameters
ist_hie <- IndSTPrior("hierarchical", list(1,2,10,1), list(3,4,5,6))

#Hierarchical priors with gamma(1,2) and gamma(10, 1) on the variance hyperparameters and
#the beta conjugate prior with parameters (p = 0.75, q = 0.75, k = 0.2) on the
#correlation hyperparameters
ist_hie_beta_conj <- IndSTPrior("hierarchical_beta_conjugate",
list(1,2,10,1), list(0.75,0.75,0.2))

#Inverse Wishart correlation priors. Gamma(2, 1/3) priors are on the variances and
#inv-Wishart(5, diag(5)) on the correlation matrices.
ist_inW <- IndSTPrior("inv_wishart", list(2, 1/3),list(5, diag(5)))

##### TruthPrior
#Simple default truth prior with 7 variables of interest
truth_def <- TruthPrior(7)
# A more fine-tuned truth prior for an ensemble with 7 species.
truth_cus <- TruthPrior(7, initial_mean = 2, initial_var = 10, rw_covariance = list(10, diag(7)))

#The default priors for an ensemble with 8 variables of interest
priors <- EnsemblePrior(8)

#With 4 variables of interest.
priors <- EnsemblePrior(4)

#Defining custom priors for a model with 4 species.
num_species <- 5
priors <- EnsemblePrior(
  d = num_species,
  ind_st_params = IndSTPrior("lkj",  list(3, 2), 3, AR_params = c(2,4)),
  ind_lt_params = IndLTPrior(
    "beta",
    list(c(10,4,8, 7,6),c(2,3,1, 4,4)),
    list(matrix(5, num_species, num_species),
         matrix(0.5, num_species, num_species))
  ),
  sha_st_params = ShaSTPrior("inv_wishart",list(2, 1/3),list(5, diag(num_species))),
  sha_lt_params = 5,
  truth_params = TruthPrior(d = num_species, initial_mean = 5, initial_var = 10,
                            rw_covariance = list(10, diag(10)))
)

}
\references{
Spence et. al. (2018). A general framework for combining ecosystem models. \emph{Fish and Fisheries}, 19(6):1031-1042.
}
