% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uni_smapJI.R
\name{uniJI}
\alias{uniJI}
\title{Univariate S-map Jacobian index function}
\source{
Grziwotz, F., Chang, C.-W., Dakos, V., van Nes, E.H., Schwarzländer, M., Kamps, O., et al. (2023). Anticipating the occurrence and type of critical transitions. Science Advances, 9.
}
\usage{
uniJI(data, winsize = 50, theta_seq = NULL, E = 1, tau = NULL, scale = TRUE)
}
\arguments{
\item{data}{Numeric matrix with time in first column and species abundance in the second}

\item{winsize}{Numeric. Defines the window size of the rolling window as a percentage of the time series length.}

\item{theta_seq}{Numeric vector of thetas (nonlinear tuning parameters) to estimate the Jacobian over. If `NULL`, a default sequence is provided.}

\item{E}{Numeric. The embedding dimension. Is suggested to be positive.}

\item{tau}{Numeric. The time-delay offset to use for time delay embedding. Suggested to be positive here, but if not provided, is set to 10\% the length of the time series.}

\item{scale}{Boolean. Should data be scaled prior to estimating the Jacobian.}
}
\value{
A dataframe where the first column is last time index of the window and the second column is the estimated index value. A value <1.0 indicates stability, a value >1.0 indicates instability.
}
\description{
Calculate a stability metric from the s-map estimated Jacobian of a univariate time series
}
\examples{
#Load the multivariate simulated
#dataset `simTransComms`

data(simTransComms)

#Subset the second community prior to the transition

pre_simTransComms <- subset(simTransComms$community2,time < inflection_pt)

#Estimate the univariate stability index for the first species in
#the second community

egJI <- uniJI(data = pre_simTransComms[1:25,2:3],
winsize = 75, E = 3)

}
