% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_functions}
\alias{plot_functions}
\title{Plots the charging function, the electricity price function and the optimal cost function}
\usage{
plot_functions(a, alpha, beta, delta, gamma, tau, R, x_values, y_values)
}
\arguments{
\item{a}{vector with the breaking points of charging function in the x-axis}

\item{alpha}{vector with the slopes of the charging function on each segment}

\item{beta}{vector with the y-intercepts of the charging function on each segment}

\item{delta}{vector with the times duration of each segment of electricity price function}

\item{gamma}{vector with the prices of the electricity on each segment of electricity price function}

\item{tau}{consumption of the vehicle (numerical value)}

\item{R}{range of the vehicle (numerical value)}

\item{x_values}{vector with the x-values of the breaking points of the charging cost function}

\item{y_values}{vector with the y-values of the breaking points of the charging cost function}
}
\value{
A plot with the charging function, the electricity price function and the optimal cost function
}
\description{
Function that plots the charging function, the electricity price function and the optimal cost function
}
\examples{
a <- c(0,3.3,6.6,10)
alpha <- c(0.1757576, 0.07272727, 0.05294118)
beta <- c(0, 0.34, 0.4705882)
delta <- c(4, 3, 5)
gamma <- c(0.45, 0.25, 0.5)
tau <- 0.15
R <- 250
opt_cost_function = minimum_cost(a, alpha, beta, delta, gamma, tau, R)
xvalues <- opt_cost_function[["xvalues"]]
yvalues <- opt_cost_function[["yvalues"]]
plot_functions(a, alpha, beta, delta, gamma, tau, R, xvalues, yvalues)
}
