% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviant_update.R
\name{deviant_update}
\alias{deviant_update}
\title{This function is used after first running the deviant function}
\usage{
deviant_update(
  all_cases = NA,
  new_cases = NA,
  EVI_input,
  cum = FALSE,
  r_a = 7,
  r = 0.2,
  lag_max = 30,
  method = "EVI",
  past = 364/2
)
}
\arguments{
\item{all_cases}{the time series of the previous and newly observed cases per unit of time (ideally per day).}

\item{new_cases}{the time series of the newly observed cases per unit of time (ideally per day).}

\item{EVI_input}{the previous EVI function output}

\item{cum}{TRUE if the time series is recorded as the cumulative number of the reported cases and FALSE (the default) if newly reported cases per unit of time are recorded.}

\item{r_a}{The window size for the moving average that will be analyzed. If set to 1 the actual observations are analyzed. However, due to the variability of the reported cases between working days and weekends it is recommended that the 7-day moving average is analyzed (i.e. r_a = 7), which is the default for this argument. Users could prefer a longer interval of 14 days or one month (i.e., r_a=14 or 30, respectively).}

\item{r}{Definition for the minimum difference in the mean number of cases, one week before and after each time point that, if present, should be detected. This is the case definition and the default is 0.2 (with 0 <= r <= 1). A value of r=0.2 means that we have a case when the mean number of the newly observed cases in the next 7 days is at least 20\% higher than the mean number of the newly observed cases in the past 7 days.}

\item{lag_max}{Integer. Restriction of the maximum window size for the rolling window size. The default is set to one month (lag_max=30) to prevent excess volatility of past epidemic waves from affecting the most recent volatility estimates and the ability of EVI to warn for upcoming waves that may be smaller and of lower volatility than previous ones.}

\item{method}{either "EVI" or "cEVI", default equals to "EVI".}

\item{past}{Integer. Default the full length of the input data series. Restriction on the historical data that EVI/cEVI will use. This is fixed and equal to the index used in the deviant function.}
}
\description{
Once the \code{\link[EVI:deviant]{deviant()}} function has been used to analyze the already observed time series,
the deviant_update() function is used to obtain the EVI output and early warnings for the new cases that are recorded.
After running the deviant_update() function the output of the deviant function is also updated with a new row of data for each newly observed time point.
}
\examples{
## Single update ##
# If we have first observed only the 148 cases from the 
# Italian data we run the deviant function on these cases:

data("Italy")
EVI_output0<-deviant(new_cases=Italy$Cases[20:35], cum=FALSE, r_a=7, r=0.2, lag_max=30)
# EVI_output0<-deviant(new_cases=Italy$Cases[1:148], cum=FALSE, r_a=7, r=0.2, lag_max=30)
# When the number of cases for the next day is observed we want to obtain 
# the estimates for this day without having to reanalyze the entire time series.
 
# This is done by using the deviant_update function:

EVI_output0<-deviant_update(new_cases=Italy$Cases[36], 
                            EVI_input=EVI_output0,
                            cum=FALSE, r_a=7, r=0.2, lag_max=30)

# EVI_output0<-deviant_update(new_cases=Italy$Cases[149], 
#                             EVI_input=EVI_output0,
#                             cum=FALSE, r_a=7, r=0.2, lag_max=30)
# The result of running the deviant_update function is to update the output of 
# the deviant_function by adding an additional row with estimates for the new data.

# In this example the EVI_output file will now have 149 rows. If two additional 
# days are analyzed two additional rows will be added and so on.



# Multiple update steps when new data come using either an EVI or cEVI updater ##
data("Italy")
EVI_output<-deviant(new_cases=Italy$Cases[1:20], cum=FALSE, 
                   r_a=7, r=0.2, lag_max=30,method = "EVI")

EVI_output2<-deviant_update(new_cases = c(100,93,80,54,12), 
                           EVI_input=EVI_output,method = "EVI")

#EVI_output2

# Same as above EVI_output2

#EVI_output2<-deviant_update(all_cases = c(Italy$Cases[1:20],100,93,80,54,12),
#EVI_input=EVI_output,method = "EVI")

#EVI_output2

#EVI_output3<-deviant_update(new_cases = c(2,2,10,1,0),EVI_input=EVI_output2, 
#method = "cEVI")

#EVI_output3

# Even though EVI and cEVI can be used interchangeably, we suggest users to 
# stick to the initial method.

}
\references{
Pateras K, Meletis E, Denwood M, et al. The convergence epidemic index (cEVI) an early warning tool for identifying waves in an epidemic. Inf Dis Mod, (2023). \doi{10.1016/j.idm.2023.05.001}
Kostoulas P, Meletis E, Pateras K, et al. The epidemic volatility index, a novel early warning tool for identifying new waves in an epidemic. Sci Rep 11, 23775 (2021). \doi{10.1038/s41598-021-02622-3}
}
