% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_phase1.R
\name{run_phase1_single}
\alias{run_phase1_single}
\title{Phase 1 wrapper for single observation}
\usage{
run_phase1_single(
  partition,
  startingestimates,
  z.obs,
  nodes,
  effects,
  objects,
  burnin,
  thining,
  gainfactor,
  a.scaling,
  r.truncation.p1,
  length.p1,
  neighborhood,
  fixed.estimates,
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  parallel = TRUE,
  cpus = 1,
  verbose = FALSE
)
}
\arguments{
\item{partition}{observed partition}

\item{startingestimates}{vector containing initial parameter values}

\item{z.obs}{observed statistics}

\item{nodes}{node set (data frame)}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{burnin}{integer for the number of burn-in steps before sampling}

\item{thining}{integer for the number of thining steps between sampling}

\item{gainfactor}{gain factor (useless now)}

\item{a.scaling}{scaling factor}

\item{r.truncation.p1}{truncation factor (for stability)}

\item{length.p1}{number of samples for phase 1}

\item{neighborhood}{vector for the probability of choosing a particular transition in the chain}

\item{fixed.estimates}{if some parameters are fixed, list with as many elements as effects, these elements equal a fixed value if needed, or NULL if they should be estimated}

\item{numgroups.allowed}{vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{vector containing the number of groups simulated}

\item{sizes.allowed}{vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{vector of group sizes allowed in the Markov chain but not necessarily sampled (now, it only works for vectors like size_min:size_max)}

\item{parallel}{boolean to indicate whether the code should be run in parallel}

\item{cpus}{number of cpus if parallel = TRUE}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
a list
}
\description{
Phase 1 wrapper for single observation
}
