% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_Metropolis.R
\name{draw_Metropolis_multiple}
\alias{draw_Metropolis_multiple}
\title{Draw Metropolis multiple}
\usage{
draw_Metropolis_multiple(
  theta,
  first.partitions,
  presence.tables,
  nodes,
  effects,
  objects,
  burnin,
  thining,
  num.steps,
  neighborhood = c(0.7, 0.3, 0),
  numgroups.allowed,
  numgroups.simulated,
  sizes.allowed,
  sizes.simulated,
  return.all.partitions = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{theta}{model parameters}

\item{first.partitions}{starting partition for the Markov chain}

\item{presence.tables}{matrix indicating which actors were present for each observations (mandatory)}

\item{nodes}{node set (data frame)}

\item{effects}{effects/sufficient statistics (list with a vector "names", and a vector "objects")}

\item{objects}{objects used for statistics calculation (list with a vector "name", and a vector "object")}

\item{burnin}{integer for the number of burn-in steps before sampling}

\item{thining}{integer for the number of thining steps between sampling}

\item{num.steps}{number of samples}

\item{neighborhood}{= c(0.7,0.3,0), way of choosing partitions: probability vector (2 actors swap, merge/division, single actor move, single pair move, 2 pairs swap, 2 groups reshuffle)}

\item{numgroups.allowed}{= NULL, # vector containing the number of groups allowed in the partition (now, it only works with vectors like num_min:num_max)}

\item{numgroups.simulated}{= NULL, # vector containing the number of groups simulated}

\item{sizes.allowed}{= NULL,  vector of group sizes allowed in sampling (now, it only works for vectors like size_min:size_max)}

\item{sizes.simulated}{= NULL, vector of group sizes allowed in the Markov chain but not necessraily sampled (now, it only works for vectors like size_min:size_max)}

\item{return.all.partitions}{= FALSE, option to return the sampled partitions on top of their statistics (for GOF)}

\item{verbose}{logical: should intermediate results during the estimation be printed or not? Defaults to FALSE.}
}
\value{
A list
}
\description{
Function to sample the model with a Markov chain (single partition procedure).
}
\examples{
# define an arbitrary set of n = 6 nodes with attributes, and an arbitrary covariate matrix
n <- 6 
nodes <- data.frame(label = c("A","B","C","D","E","F"),
                    gender = c(1,1,2,1,2,2),
                    age = c(20,22,25,30,30,31)) 
friendship <- matrix(c(0, 1, 1, 1, 0, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 1, 0,
                       1, 0, 0, 0, 0, 0,
                       0, 1, 1, 0, 0, 1,
                       0, 0, 0, 0, 1, 0), 6, 6, TRUE) 

# specify whether nodes are present at different points of time
presence.tables <- matrix(c(1, 1, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1,
                            1, 0, 1, 1, 1, 1), 6, 3)

# choose effects to be included in the estimated model
effects_multiple <- list(names = c("num_groups","same","diff","tie","inertia_1"),
                objects = c("partitions","gender","age","friendship","partitions"),
                objects2 = c("","","","",""))
objects_multiple <- list()
objects_multiple[[1]] <- list(name = "friendship", object = friendship)

# set parameter values for each of these effects
parameters <- c(-0.2,0.2,-0.1,0.5,1)

# set a starting point for the simulation
first.partitions <- matrix(c(1, 1, 2, 2, 2, 3,
                             NA, 1, 1, 2, 2, 2,
                             1, NA, 2, 3, 3, 1), 6, 3) 

\donttest{
# generate the simulated sample
nsteps <- 50
sample <- draw_Metropolis_multiple(theta = parameters, 
                                   first.partitions = first.partitions,
                                   nodes = nodes, 
                                   presence.tables = presence.tables,
                                   effects = effects_multiple, 
                                   objects = objects_multiple, 
                                   burnin = 100, 
                                   thining = 100, 
                                   num.steps = nsteps, 
                                   neighborhood = c(0,1,0), 
                                   numgroups.allowed = 1:n,
                                   numgroups.simulated = 1:n,
                                   sizes.allowed = 1:n,
                                   sizes.simulated = 1:n,
                                   return.all.partitions = TRUE)
}

}
