% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSELM.R
\name{OSelm_training}
\alias{OSelm_training}
\title{Trains an online sequential extreme learning machine with random weights}
\usage{
OSelm_training(p, y, Elm_Type, nHiddenNeurons, ActivationFunction, N0, Block)
}
\arguments{
\item{p}{dataset used to perform the training of the model}

\item{y}{classes vector for classiication or regressors for regression}

\item{Elm_Type}{select if the ELM must perform a "regression" or "classification"}

\item{nHiddenNeurons}{number of neurons in the hidden layer}

\item{ActivationFunction}{"rbf" for radial basis function with Gaussian kernels , "sig" for sigmoidal fucntion, "sin" for sine function, "hardlim" for hard limit function}

\item{N0}{size of the first block to be processed}

\item{Block}{size of each chunk to be processed at each step}
}
\value{
returns all the parameters used in the function, the weight matrix, the labels for the classification, the number of classes found, the bias, the beta activation function and the accuracy on the trainingset
}
\description{
Trains an online sequential extreme learning machine with random weights
}
\examples{
x = runif(100, 0, 50)
y = sqrt(x)
train = data.frame(y,x)
train = data.frame(preProcess(train))
OSelm_train.formula(y~x, train, "regression", 100, "hardlim", 10, 10)
}
\references{
[1] N.-Y. Liang, G.-B. Huang, P. Saratchandran, and N. Sundararajan, 'A Fast and Accurate On-line Sequential Learning Algorithm for Feedforward Networks' IEEE Transactions on Neural Networks, vol. 17, no. 6, pp. 1411-1423, 2006
}

