% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\docType{class}
\name{elisa_plate-class}
\alias{elisa_plate-class}
\title{S4 class definition of an elisa_plate object}
\arguments{
\item{batchID}{characters to specify the batch}

\item{expID}{characters to specify experiment or plate ID}

\item{desc}{characters for the data/experiment information}

\item{data.std}{data.frame for standard curve data}

\item{data.unknown}{data.frame containing data for samples with unknown concentration}

\item{normFactor}{numeric the correction factor for batch effects ("S").}

\item{mdata.unknown}{data.frame containing the mean ODs and concentration by sample IDs.}

\item{mdata.std}{data.frame containing the mean ODs and concentrations for standard data}
}
\description{
\code{\link{elisa_plate}} define the S4 class of an elisa_plate object
}
\details{
defining the S4 class of the elisa_plate object.
This is the data structure to hold the elisa_plate Data. 
	It contains different slots for holding both standard and 
   unknown data. It also defines 
   the regression model and the correction parameter 
  for the batch effects.\cr  
Note: we assume each plate has its own standard curve.
}
\section{Slots}{

\describe{
\item{\code{batchID}}{character}

\item{\code{expID}}{character}

\item{\code{data.std}}{data.frame}

\item{\code{data.unknown}}{data.frame}

\item{\code{normFactor}}{numeric}

\item{\code{desc}}{character}

\item{\code{range.ODs}}{numeric}

\item{\code{mdata.unknown}}{data.frame}

\item{\code{mdata.std}}{data.frame}
}}

\examples{
elisa_plate();
}
\seealso{
\code{\link[minpack.lm]{nls.lm}}
}
\concept{ELISA}
