% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genTEFI.R
\name{genTEFI}
\alias{genTEFI}
\title{Generalized Total Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
genTEFI(data, structure = NULL, verbose = TRUE)
}
\arguments{
\item{data}{Matrix, data frame, or \code{\link[EGAnet]{hierEGA}} object.
Can be raw data or correlation matrix}

\item{structure}{For high-order and correlated bifactor structures,
\code{structure} should be a list containing:

\itemize{

\item \code{lower_order} --- A vector (length = \code{ncol(data)}) representing the first-order structure 
(numbers or labels for each item in each first-order factor or community)

\item \code{higher_order} --- A vector (length = \code{ncol(data)} or number of \code{lower_order} communities)representing 
the second-order structure (numbers or labels for each item in each second-order 
factor or community)

}}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{TRUE} to see all messages and warnings for every 
function call.
Set to \code{FALSE} to ignore messages and warnings}
}
\value{
Returns a three-column data frame of the Generalized Total Entropy 
Fit Index using Von Neumman's entropy (\code{VN.Entropy.Fit}) (first column), as well as
\code{Lower.Order.VN} - TEFI for the first-order factors (second column), and
\code{Higher.Order.VN}, the equivalent for the second-order factors.
}
\description{
Computes the fit (Generalized TEFI) of a hierarchical or correlated bifactor 
dimensionality structure (or \code{\link{hierEGA}} objects) using Von Neumman's entropy 
when the input is a correlation matrix. Lower values suggest better fit of a structure to the data
}
\examples{
# Example using network scores
opt.hier <- hierEGA(
  data = optimism, scores = "network",
  plot.EGA = FALSE # No plot for CRAN checks
)

# Compute the Generalized Total Entropy Fit Index
genTEFI(opt.hier)

}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
