% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{setPredCalibration<-}
\alias{setPredCalibration<-}
\alias{setPredCalibration<-,ForecastData-method}
\alias{setPredTest<-}
\alias{setPredTest<-,ForecastData-method}
\alias{setOutcomeCalibration<-}
\alias{setOutcomeCalibration<-,ForecastData-method}
\alias{setOutcomeTest<-}
\alias{setOutcomeTest<-,ForecastData-method}
\alias{setModelNames<-}
\alias{setModelNames<-,ForecastData-method}
\title{"Set" functions}
\usage{
setPredCalibration(object) <- value

\S4method{setPredCalibration}{ForecastData}(object) <- value

setPredTest(object) <- value

\S4method{setPredTest}{ForecastData}(object) <- value

setOutcomeCalibration(object) <- value

\S4method{setOutcomeCalibration}{ForecastData}(object) <- value

setOutcomeTest(object) <- value

\S4method{setOutcomeTest}{ForecastData}(object) <- value

setModelNames(object) <- value

\S4method{setModelNames}{ForecastData}(object) <- value
}
\arguments{
\item{object}{The object to which values are assigned.}

\item{value}{Values to be assigned.}
}
\value{
A data object of the class 'ForecastData' with the following slots: 
\item{predCalibration}{An array containing the predictions of all component models for all observations in the calibration period.} 
\item{predTest}{An array containing the predictions of all component models for all observations in the test period.}
\item{outcomeCalibration}{A vector containing the true values of the dependent variable for all observations in the calibration period.} 
\item{outcomeTest}{A vector containing the true values of the dependent variable for all observations in the test period.}
\item{modelNames}{A character vector containing the names of all component models.  If no model names are specified, names will be assigned automatically.}
}
\description{
To assign individual slots, use set functions
}
\examples{

\dontrun{
data(calibrationSample)
data(testSample)
setPredCalibration(this.ForecastData)<-calibrationSample[,c("LMER", "SAE", "GLM")]
setOutcomeCalibration(this.ForecastData)<-calibrationSample[,"Insurgency"]
setPredTest(this.ForecastData)<-testSample[,c("LMER", "SAE", "GLM")]
setOutcomeTest(this.ForecastData)<-testSample[,"Insurgency"]
setModelNames(this.ForecastData)<-c("LMER", "SAE", "GLM")
}

}
\references{
Montgomery, Jacob M., Florian M. Hollenbach and Michael D. Ward. (2012). Improving Predictions Using Ensemble Bayesian Model Averaging. \emph{Political Analysis}. \bold{20}: 271-291.

Montgomery, Jacob M., Florian M. Hollenbach and Michael D. Ward. (2015). Calibrating ensemble forecasting models with sparse data in the social sciences. \emph{International Journal of Forecasting}. \bold{31}:930–942.#'
}
\author{
Michael D. Ward <\email{michael.d.ward@duke.edu}> and Jacob M. Montgomery <\email{jacob.montgomery@wustl.edu}> and Florian M. Hollenbach <\email{florian.hollenbach@tamu.edu}>
}
